use Spatie\Permission\Exceptions\UnauthorizedException;

public function render($request, Exception $exception)
{
    if ($exception instanceof UnauthorizedException) {
        if ($request->user() && $request->user()->hasRole('scanner')) {
            return redirect()->route('users.scanner')
                ->with('error', 'You are not authorized to access this section.');
        }
    }

    return parent::render($request, $exception);
}