<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ComplimentaryTicket extends Model
{
    use HasFactory;

    protected $table = 'complimentary_tickets';

    protected $fillable = [
        'event_id',
        'first_name',
        'last_name',
        'phone',
        'email',
        'school',
        'quantity',
        'reference',
        'complimentary_code',
        'ticket_type',
        'is_scanned',
        'scanned_at',
        'scanned_by',
    ];

    protected $casts = [
        'is_scanned' => 'boolean',
        'scanned_at' => 'datetime',
    ];

    public function event()
    {
        return $this->belongsTo(Event::class);
    }

    public function complimentaryCode()
    {
        return $this->belongsTo(ComplimentaryCode::class, 'complimentary_code', 'code');
    }
}