<?php

return [
    'default' => env('MAIL_MAILER', 'pacesetter'),

    'mailers' => [
        'smtp' => [
            'transport' => 'smtp',
            'host' => env('MAIL_HOST', 'mail.pacesetter.co.ke'),
            'port' => env('MAIL_PORT', 465),
            'encryption' => env('MAIL_ENCRYPTION', 'ssl'),
            'username' => env('MAIL_USERNAME'),
            'password' => env('MAIL_PASSWORD'),
            'timeout' => null,
            'local_domain' => env('MAIL_EHLO_DOMAIN'),
        ],

        'pacesetter' => [
            'transport' => 'smtp',
            'host' => env('PACESETTER_MAIL_HOST', 'mail.pacesetter.co.ke'),
            'port' => env('PACESETTER_MAIL_PORT', 465),
            'encryption' => env('PACESETTER_MAIL_ENCRYPTION', 'ssl'),
            'username' => env('PACESETTER_MAIL_USERNAME', 'complimentary@pacesetter.co.ke'),
            'password' => env('PACESETTER_MAIL_PASSWORD'),
            'timeout' => null,
            'verify_peer' => false,
        ],

        'ses' => [
            'transport' => 'ses',
        ],

        'postmark' => [
            'transport' => 'postmark',
            'token' => env('POSTMARK_TOKEN'),
        ],

        'log' => [
            'transport' => 'log',
            'channel' => env('MAIL_LOG_CHANNEL'),
        ],

        'array' => [
            'transport' => 'array',
        ],

        'failover' => [
            'transport' => 'failover',
            'mailers' => [
                'pacesetter',
                'smtp',
                'log',
            ],
        ],
    ],

    'from' => [
        'address' => env('MAIL_FROM_ADDRESS', 'complimentary@pacesetter.co.ke'),
        'name' => env('MAIL_FROM_NAME', 'Pacesetter Complimentary Tickets'),
    ],

    'markdown' => [
        'theme' => 'default',

        'paths' => [
            resource_path('views/vendor/mail'),
        ],
    ],
];