<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique()->nullable(); // Made nullable for phone-based users
            $table->string('phone')->unique()->nullable(); // Added phone field
            $table->timestamp('phone_verified_at')->nullable(); // For phone verification
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password')->nullable(); // Made nullable for social/phone auth
            $table->string('otp')->nullable(); // For storing temporary OTP
            $table->timestamp('otp_expires_at')->nullable(); // OTP expiration
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes(); // Added soft delete
        });

        // Schema::create('password_reset_tokens', function (Blueprint $table) {
        //     $table->string('email')->primary();
        //     $table->string('token');
        //     $table->timestamp('created_at')->nullable();
        // });

        // // Updated password reset tokens to include phone
        // Schema::create('password_reset_tokens', function (Blueprint $table) {
        //     $table->string('email')->index()->nullable();
        //     $table->string('phone')->index()->nullable();
        //     $table->string('token');
        //     $table->timestamp('created_at')->nullable();
        // });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
        // Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};