<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sms_logs', function (Blueprint $table) {
            $table->id();
            $table->string('contact_name');
            $table->string('phone_number');
            $table->string('school_name')->nullable();
            $table->text('message_content');
            $table->string('status')->default('pending'); // pending, sent, failed
            $table->text('response_data')->nullable(); // API response from Wassilian
            $table->string('message_id')->nullable(); // External message ID from provider
            $table->decimal('cost', 8, 2)->nullable(); // SMS cost
            $table->integer('parts')->default(1); // Number of SMS parts
            $table->timestamp('sent_at')->nullable();
            $table->string('campaign_name')->nullable(); // For grouping messages
            $table->timestamps();

            // Indexes for better performance
            $table->index(['phone_number', 'created_at']);
            $table->index('status');
            $table->index('campaign_name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sms_logs');
    }
};
