<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('complimentary_codes', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique();
            $table->foreignId('event_id')->constrained();
            $table->string('generated_by_name');
            $table->boolean('is_used')->default(false);
            $table->timestamp('used_at')->nullable();
            $table->string('used_by_name')->nullable();
            $table->timestamp('expires_at');
            $table->text('notes')->nullable();
            
            // Recipient information
            $table->string('recipient_name');
            $table->string('recipient_phone', 20);
            $table->string('recipient_email')->nullable();
            $table->integer('ticket_quantity')->default(1);
            $table->integer('redeemed_count')->default(0);
            
            // Distribution tracking
            $table->timestamp('sent_at')->nullable();
            $table->string('sms_status')->default('pending');
            $table->string('sms_error')->nullable();
            $table->string('sent_to')->nullable();
            
            $table->timestamps();

            // Indexes
            $table->index('is_used');
            $table->index('expires_at');
            $table->index('sms_status');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('complimentary_codes');
    }
};