<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateComplimentaryTicketsTable extends Migration
{
    public function up()
    {
        Schema::create('complimentary_tickets', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('event_id');
            $table->string('first_name', 255);
            $table->string('last_name', 255);
            $table->string('phone', 20);
            $table->string('email', 255);
            $table->string('school', 255);
            $table->integer('quantity')->default(1);
            $table->string('reference')->unique();
            $table->string('complimentary_code')->nullable();
            $table->boolean('is_scanned')->default(false);
            $table->timestamp('scanned_at')->nullable();
            $table->string('scanned_by', 255)->nullable();
            $table->timestamps();

            $table->foreign('event_id')->references('id')->on('events')->onDelete('cascade');
            $table->foreign('complimentary_code')->references('code')->on('complimentary_codes')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('complimentary_tickets');
    }
}
