<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTicketTypeToComplimentaryCodesTable extends Migration
{
    public function up()
    {
        Schema::table('complimentary_codes', function (Blueprint $table) {
            $table->enum('ticket_type', ['normal', 'vip'])->default('normal')->after('ticket_quantity');
        });
    }

    public function down()
    {
        Schema::table('complimentary_codes', function (Blueprint $table) {
            $table->dropColumn('ticket_type');
        });
    }
}
