<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    public function run()
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create permissions
        $permissions = [
            // User Management Permissions
            'view-users',
            'create-users', 
            'edit-users',
            'delete-users',
            
            // Existing permissions
            'access-messages',
            'manage-contacts', 
            'view-tickets',
            'view-metrics',
            'access-complimentary'
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create roles and assign permissions using firstOrCreate
        $superAdmin = Role::firstOrCreate(['name' => 'super-admin']);
        $superAdmin->givePermissionTo(Permission::all());

        $customerSupport = Role::firstOrCreate(['name' => 'customer-support']);
        $customerSupport->givePermissionTo([
            'access-messages', 
            'manage-contacts', 
            'view-tickets'
        ]);

        $management = Role::firstOrCreate(['name' => 'management']);
        $management->givePermissionTo([
            'view-users',        // Management can view users
            'view-tickets', 
            'view-metrics'
        ]);
    }
}