<!DOCTYPE html>
<html class="no-js" lang="en">
  <head>
    <meta charset="utf-8" />
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <title>PACE</title>
    <meta name="description" content="PACE Events" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <link
      rel="shortcut icon"
      type="image/x-icon"
      href="{{ asset('assets/img/logo/logo.png') }}"
    />
    <!-- Place favicon.ico in the root directory -->

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- CSS here -->
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/animate.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/magnific-popup.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/fontawesome-all.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/flaticon_mycollection.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/swiper-bundle.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/odometer.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/default.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/main.css') }}" />
    <style>
        .contact-form-container {
          background: linear-gradient(to right, rgb(252, 249, 249), rgb(243, 241, 241), white);
          box-shadow: -5px 5px 15px rgba(1, 6, 36, 0.5);
          border-radius: 8px;
          padding: 30px;
        }
      
        .form-input {
          box-shadow: 0 4px 10px rgba(248, 247, 247, 0.979);
          border: none;
          border-radius: 5px;
          padding: 12px;
        }
      
        .form-btn {
          background-color: #6c04f5;
          color: white;
          border: none;
          border-radius: 5px;
          padding: 12px;
          box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
          justify-content: center;
          align-self: center;
        }
      
        .form-btn:hover {
          background-color: #db2777;
          color: white;
        }
            .td-breadcrumb-area {
              position: relative;
              background: url("{{ asset('assets/img/logo/logo.png') }}") center center / cover no-repeat;
            }
            .td-breadcrumb-area::before {
              content: "";
              position: absolute;
              inset: 0;
              background: rgba(0, 0, 0, 0.5); /* Adjust opacity as needed */
            }
            .td-breadcrumb-area .container {
              position: relative;
              z-index: 1;
            }
           #termsModal .modal-content {
          border-radius: 10px;
          overflow: hidden;
        }

        #termsModal .modal-body {
          background-color: #f8f9fa;
        }

        #termsModal iframe {
          border: none;
          width: 100%;
          height: 100%;
          display: block;
        }
          
      </style>
  </head>

  <body>
    <!-- Preloader Start -->
    <div class="preloader">
      <div class="loader"></div>
    </div>
    <!-- Preloader End -->

    <!-- Scroll-top -->
    <button class="scroll__top scroll-to-target" data-target="html">
      <i class="fa-sharp fa-regular fa-arrow-up"></i>
    </button>
    <!-- Scroll-top-end-->

    <!-- header-search -->
    <div class="search__popup">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="search__wrapper">
              <div class="search__close">
                <button type="button" class="search-close-btn">
                  <svg
                    width="18"
                    height="18"
                    viewBox="0 0 18 18"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      d="M17 1L1 17"
                      stroke="currentColor"
                      stroke-width="1.5"
                      stroke-linecap="round"
                      stroke-linejoin="round"
                    ></path>
                    <path
                      d="M1 1L17 17"
                      stroke="currentColor"
                      stroke-width="1.5"
                      stroke-linecap="round"
                      stroke-linejoin="round"
                    ></path>
                  </svg>
                </button>
              </div>
              <div class="search__form">
                {{-- <form action="#"> --}}
                  <div class="search__input">
                    <input
                      class="search-input-field"
                      type="text"
                      placeholder="Type keywords here"
                    />
                    <span class="search-focus-border"></span>
                    <button type="submit">
                      <svg
                        width="20"
                        height="20"
                        viewBox="0 0 20 20"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M9.55 18.1C14.272 18.1 18.1 14.272 18.1 9.55C18.1 4.82797 14.272 1 9.55 1C4.82797 1 1 4.82797 1 9.55C1 14.272 4.82797 18.1 9.55 18.1Z"
                          stroke="currentColor"
                          stroke-width="1.5"
                          stroke-linecap="round"
                          stroke-linejoin="round"
                        ></path>
                        <path
                          d="M19.0002 19.0002L17.2002 17.2002"
                          stroke="currentColor"
                          stroke-width="1.5"
                          stroke-linecap="round"
                          stroke-linejoin="round"
                        ></path>
                      </svg>
                    </button>
                  </div>
                {{-- </form> --}}
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="search-popup-overlay"></div>
    <!-- header-search-end -->

    <!-- cart mini area start -->

    <div class="body-overlay"></div>
    <!-- cart mini area end -->

    <!-- header-area -->
    <header class="td-header-height">
      <div class="td-header__area z-index-999 td-transparent">
        <div class="td-header-3-top d-none d-lg-block">
          <div class="container-fluid container-1680">
            <div class="row">
              <div class="col-lg-6">
                <div class="td-header-3-top-info">
                  <span
                    ><a href="#"
                      ><i class="flaticon-gps"></i>Nairobi, Kenya</a
                    ></span
                  >
                  <span class="dvdr">/</span>
                  <span
                    ><a href="tel:+254726846918"
                      ><i class="flaticon-phone"></i>+254 726-846 918</a
                    ></span
                  >
                </div>
              </div>
              <div class="col-lg-6">
                <div class="d-none d-lg-block">
                  <div
                    class="td-header-3-top-social d-flex align-items-center justify-content-end"
                  >
                    <span class="td-email"
                      ><a href="mailto:thepacesettertalentshow@gmail.com"
                        ><i class="flaticon-mail"></i>Thepacesettertalentshow@gmail.com</a
                      ></span
                    >
                    <span class="dvdr">/</span>
                    <span
                      ><a href="https://www.facebook.com/p/The-Pace-setter-Mag-61550425191042/"><i class="fa-brands fa-facebook"></i></a
                    ></span>
                    <span>
                      <a href="#">
                        <svg
                          width="19"
                          height="19"
                          viewBox="0 0 19 19"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path
                            d="M13.8679 1.60596H16.4382L10.8229 8.02398L17.4289 16.7575H12.2564L8.20515 11.4607L3.56956 16.7575H0.997689L7.00391 9.89267L0.666687 1.60596H5.97049L9.6325 6.44745L13.8679 1.60596ZM12.9658 15.219H14.3901L5.1966 3.06361H3.66824L12.9658 15.219Z"
                            fill="currentColor"
                          />
                        </svg>
                      </a>
                    </span>
                    <span
                      ><a href="https://www.facebook.com/p/The-Pace-setter-Mag-61550425191042/"><i class="fa-brands fa-instagram"></i></a
                    ></span>
                    <span
                      ><a href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event"><i class="fa-brands fa-whatsapp"></i></a
                    ></span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div id="header-sticky" class="header-mobile-spacing">
          <div class="container-fluid container-1680">
            <div class="row align-items-center">
              <div class="col-xxl-9 col-xl-9 col-6">
                <div
                  class="tdmenu__wrap d-flex align-items-center justify-content-between"
                >
                  <div class="logo">
                    <a class="logo-1 logo-sticky-none" href="/"
                      ><img
                        data-width="150"
                        src="{{ asset('assets/img/logo/logo.png') }}"
                        alt="Logo"
                    /></a>
                    <a class="logo-2 d-none" href="/"
                      ><img
                        data-width="150"
                        src="{{ asset('assets/img/logo/logo.png') }}"
                        alt="Logo"
                    /></a>
                  </div>
                  <nav
                    class="mr-40 tdmenu__nav tdmenu-3 ml-50 d-none d-xl-flex"
                  >
                    <div class="tdmenu__navbar-wrap tdmenu__main-menu">
                      <ul class="navigation">
                        <li class="menu-item-has-children">
                          <a href="/">Home</a>
                        </li>
                        <li class="menu-item-has-children">
                          <a href="#">Events</a>
                        </li>
                        <li class="menu-item-has-children">
                          <a href="#">Speakers</a>
                        </li>

                        <li class="menu-item-has-children">
                          <a href="{{ route('contact') }}">Contact</a>
                        </li>
                        <li class="active">
                          <a href="{{ route('ticket', ['slug' => $highlightedEvent->slug]) }}" 
                            class="buy-ticket-link"
                            data-event-id="{{ $highlightedEvent->id }}"
                            data-amount="{{ $highlightedEvent->tickets['early_bird'] }}">
                            Buy Ticket                            
                         </a>
                        </li>
                      </ul>
                    </div>
                  </nav>
                </div>
              </div>
              <div class="col-xxl-3 col-xl-3 col-6">
                <div
                  class="td-menu-right-action td-menu-right-action-3 d-flex align-items-center justify-content-end"
                >
                  <div class="ml-20 td-header-menu-bar lh-1 p-relative">
                    <button
                      class="tdmenu-offcanvas-open-btn mobile-nav-toggler d-block d-xl-none"
                    >
                      <span></span>
                      <span></span>
                      <span></span>
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Mobile Menu  -->
      <div class="tdmobile__menu">
        <nav class="tdmobile__menu-box">
          <div class="close-btn"><i class="fa-solid fa-xmark"></i></div>
          <div class="nav-logo">
            <a href="/"
              ><img src="{{ asset('assets/img/logo/logo.png') }}" alt="logo"
            /></a>
          </div>
          
          <div class="tdmobile__menu-outer">
            <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
          </div>
          <div class="social-links">
            <ul class="list-wrap">
              <li>
                <a href="https://www.facebook.com/p/The-Pace-setter-Mag-61550425191042/"><i class="fab fa-facebook-f"></i></a>
              </li>
              <li>
                <a href="https://x.com/the_pace_mag"><i class="fab fa-twitter"></i></a>
              </li>
              <li>
                <a href="https://www.instagram.com/pace_setter_mag/"><i class="fab fa-instagram"></i></a>
              </li>
              <li>
                <a href="http://www.youtube.com/@ThePaceSetterMag"><i class="fab fa-youtube"></i></a>
              </li>
            </ul>
          </div>
        </nav>
      </div>
      <div class="tdmobile__menu-backdrop"></div>
      <!-- End Mobile Menu -->

      <!-- offCanvas-menu -->
      <div class="offCanvas__info">
        <div class="offCanvas__close-icon menu-close">
          <button><i class="fa-sharp fa-regular fa-xmark"></i></button>
        </div>
        <div class="offCanvas__logo mb-30">
          <a href="/"
            ><img src="{{ asset('assets/img/logo/logo.png') }}" alt="Logo"
          /></a>
        </div>
        <div class="offCanvas__side-info mb-30">
          <div class="contact-list mb-30">
            <h4>Office Address</h4>
            <a href="https://www.google.com/maps" target="_blank"
              >Nairobi <br />
              Kenya</a
            >
          </div>
          <div class="contact-list mb-30">
            <h4>Phone Number</h4>
            <a href="tel:(090)87658654385">+0989 7876 9865 9</a>
            <a href="tel:(090)87658654385">+(090) 8765 86543 85</a>
          </div>
          <div class="contact-list mb-30">
            <h4>Email Address</h4>
            <a href="mailto:thepacesettertalentshow@gmail.com">Thepacesettertalentshow@gmail.com</a>
          </div>
        </div>
        <div class="offCanvas__social-icon mt-30">
          <a href="javascript:void(0)"><i class="fab fa-facebook-f"></i></a>
          <a href="javascript:void(0)"><i class="fab fa-twitter"></i></a>
          <a href="javascript:void(0)"><i class="fab fa-google-plus-g"></i></a>
          <a href="javascript:void(0)"><i class="fab fa-instagram"></i></a>
        </div>
      </div>
      <div class="offCanvas__overly"></div>
      <!-- offCanvas-menu-end -->
    </header>
    <!-- header-area-end -->

    <!-- main-area -->
    <main>
      <!-- td-breadcrumb-area-start -->
      
      
      <div class="td-breadcrumb-area td-breadcrumb-spacing bg-position">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <div class="td-breadcrumb-title-wrap">
                <h2
                  class="mb-10 td-breadcrumb-title wow td-animetion-left"
                  data-wow-duration="1.5s"
                  data-wow-delay="0.3s"
                >
                  TeenzFest 2025
                </h2>
                <div
                  class="td-breadcrumb-list wow td-animetion-right"
                  data-wow-duration="1.5s"
                  data-wow-delay="0.3s"
                >
                  <ul>
                    <li><a href="/">Home</a></li>
                    <li>
                      <i class="fa-sharp fa-solid fa-angle-right fa-fw"></i>
                    </li>
                    <li class="pages">TeenzFest 2025</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- td-breadcrumb-area-end -->


      
      
<!-- td-contact-form-area-start -->
<div class="container mt-3 d-flex justify-content-center">
  <div class="contact-form-container col-lg-8 col-xl-6 col-sm-12">
    <!-- Lipa Na M-Pesa Image -->
    <div class="mb-3 text-center">
      <img src="{{ asset('assets/img/Lipa na mpesa.png') }}" alt="Lipa Na M-Pesa" style="max-height: 100px; width:200px;" class="img-fluid">
    </div>
    
    <h3 class="mb-4 text-center text-secondary">TeenzFest 2025</h3>
    <form id="contact-form" action="{{ route('buy-ticket') }}" method="POST">
      @csrf
      <div class="mb-3 row">
        <div class="col">
          <input type="text" class="form-control form-input" name="firstName" placeholder="First Name" required 
                 pattern="^[A-Za-z\s\-']+$" 
                 title="Please enter a valid first name (letters, spaces, hyphens, and apostrophes only).">
          <div class="invalid-feedback">Please enter a valid first name</div>
        </div>
        <div class="col">
          <input type="text" class="form-control form-input" name="lastName" placeholder="Last Name" required 
                 pattern="^[A-Za-z\s\-']+$" 
                 title="Please enter a valid last name (letters, spaces, hyphens, and apostrophes only).">
          <div class="invalid-feedback">Please enter a valid last name</div>
        </div>
      </div>
      <div class="mb-3">
        <input type="tel" class="form-control form-input" name="phone" placeholder="Phone Number (e.g., 0712345678)" required 
               pattern="^(?:\+254|0)?[17]\d{8}$" 
               title="Please enter a valid Kenyan phone number starting with 07, 01, +2547 or +2541 no spaces">
        <div class="invalid-feedback">Please enter a valid Kenyan phone number</div>
      </div>
      <div class="mb-3">
        <input type="email" class="form-control form-input" name="email" placeholder="Email" required 
               pattern="^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$" 
               title="Please enter a valid email address">
        <div class="invalid-feedback">Please enter a valid email address</div>
      </div>
      
      <div class="mb-3">
        <input type="text" class="form-control form-input" name="school" placeholder="School" required 
               pattern="^[A-Za-z\s\-.,&']+$" 
               title="Please enter a valid school name">
        <div class="invalid-feedback">Please enter your school name</div>
      </div>
      <div class="mb-3 position-relative">
        <select class="form-control form-input" name="ticket_quantity" required title="Please select the number of tickets.">
          <option value="" disabled selected>Select Number of Tickets</option>
          @for ($i = 1; $i <= 10; $i++)
            <option value="{{ $i }}">{{ $i }}</option>
          @endfor
        </select>
        <span class="position-absolute" style="top: 50%; right: 45px; transform: translateY(-50%); pointer-events: none; font-size: 2.4rem;">
          &#9662;
        </span>
        <div class="invalid-feedback">Please select number of tickets</div>
      </div>
      
      <!-- Hidden Input -->
      <input type="hidden" name="event_id" value="{{ $event->id }}">

      <!-- ✅ Terms & Conditions Notice -->
      <p class="mt-3 mb-3 text-center small text-muted">
        By continuing, you accept the 
        <a href="#" data-bs-toggle="modal" data-bs-target="#termsModal" class="text-decoration-none text-primary">
          Ticket Terms & Conditions
        </a>.
      </p>

      <button type="submit" class="justify-between form-btn btn-sm col-sm-12 col-lg-12 col-xl-12">
        <span class="submit-text">Buy Ticket</span>
        <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
      </button>
    </form>

    <div id="response-message" class="mt-3 text-center alert" style="display: none;"></div>
  </div>
</div>
<!-- td-contact-form-area-end -->


    
    </main>
    <!-- main-area-end -->
     <!-- Modal -->
          <div class="mb-4 modal fade" id="termsModal" tabindex="-1" aria-labelledby="termsModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered">
              <div class="modal-content">

                <div class="modal-header">
                  <h5 class="modal-title" id="termsModalLabel">Terms & Conditions</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="p-0 modal-body" style="height: 80vh;">
                  <iframe 
                    src="{{ asset('assets/Terms and conditions.pdf') }}" 
                    width="100%" 
                    height="100%" 
                    style="border:none;"
                  ></iframe>
                </div>

                <div class="modal-footer">
                  <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Close</button>
                </div>

              </div>
            </div>
          </div>

    <!-- footer-area-start -->
    <footer>
        <div
          class="td-footer-area td-footer-2-spacing bg-position bg-dark"
          data-background="assets/img/footer/bg.jpg"
        >
          <div class="container">
            <div class="row mb-15">
              <div class="col-xl-3 col-lg-3 col-md-5">
                <div class="mb-40 td-footer-widget">
                  <div class="mb-20 td-footer-logo">
                    <a href="/"
                      ><img src="{{ asset('assets/img/logo/logo.png') }}" alt="logo"
                    /></a>
                  </div>
                  <p class="mb-10 text">
                    Nairobi,Kenya
                  </p>
                  <a
                    class="mb-10 number d-inline-block"
                    href="tel:+254726846918"
                    >+(254) 726-846 918</a
                  >
                  <a class="email" href="mailto:Thepacesettertalentshow@gmail.com">Thepacesettertalentshow@gmail.com</a>
                </div>
              </div>
              <div class="col-xl-5 col-lg-4 col-md-7">
                <div class="mb-40 td-footer-widget space ml-90">
                  <h3 class="mb-20 td-footer-title">Quick links</h3>
                  <div class="row">
                    <div class="col-lg-6 col-md-6 col-sm-6">
                      <div class="td-footer-links">
                        <ul>
                          <li><a href="#">About this Event</a></li>
                          <li><a href="#">Venue</a></li>
                          <li><a href="#">Speakers</a></li>
                          <li><a href="#">Agenda</a></li>
                          <li><a href="#">Sponsors</a></li>
                        </ul>
                      </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-6">
                      <div class="td-footer-links">
                        <ul>
                          <li><a href="#">News</a></li>
                          <li>
                            <a href="{{ route('ticket', ['slug' => $highlightedEvent->slug]) }}" 
                              class="buy-ticket-link"
                              data-event-id="{{ $highlightedEvent->id }}">
                              Buy Ticket
                           </a>
                          </li>
                          
                          <li><a href="#">Benefits</a></li>
                          <li><a href="#">Contact Us</a></li>
                        </ul>
                      </div>
                    </div>
                  </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-5 col-md-6">
              <div class="mb-40 td-footer-2-widget space ml-90">
                <h3 class="td-footer-title mb-25"></h3>
                <div class="row gx-10">
                  <a aria-label="Chat on WhatsApp" 
                     href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event" 
                     target="_blank">
                    <img alt="Chat on WhatsApp" src="{{ asset('assets/img/whatsapp/WhatsAppButtonGreenLarge.png') }}" />
                  </a>
                </div>
              </div>
              
            </div>
            <div class="row">
              <div class="col-12">
                <div class="pt-40 td-footer-bottom pb-15">
                  <div class="row align-items-center">
                    <div class="col-md-9">
                      <div class="td-footer-bottom-copyright mb-30">
                        <p>
                          Copyright © <span id="current-year"></span> pacesetter.co.ke All rights reserved.
                        </p>
                        
                        
                        
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="text-right td-footer-bottom-social mb-30">
                        
                        <span
                          ><a href="https://www.instagram.com/pace_setter_mag/"><i class="fa-brands fa-instagram"></i></a
                        ></span>
                        <span>
                          <a href="https://x.com/the_pace_mag">
                            <svg
                              width="21"
                              height="18"
                              viewBox="0 0 21 18"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                d="M16.3783 0.111328H19.3942L12.8054 7.64181L20.5565 17.8891H14.4875L9.73399 11.6742L4.2949 17.8891H1.27723L8.32453 9.83441L0.888855 0.111328H7.11199L11.4087 5.79201L16.3783 0.111328ZM15.3199 16.084H16.991L6.20396 1.82164H4.41068L15.3199 16.084Z"
                                fill="currentColor"
                              />
                            </svg>
                          </a>
                        </span>
                        <span
                          ><a href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event"><i class="fa-brands fa-whatsapp"></i></a
                        ></span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </footer>
      <!-- footer-area-end -->
  

    <!-- JS here -->
    <script src="{{ asset('assets/js/vendor/jquery.js') }}"></script>
    <script src="{{ asset('assets/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/js/isotope.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/js/ion.rangeSlider.min.js') }}"></script>
    <script src="{{ asset('assets/js/imagesloaded.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.magnific-popup.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.odometer.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery-appear.js') }}"></script>
    <script src="{{ asset('assets/js/swiper-bundle.min.js') }}"></script>
    <script src="{{ asset('assets/js/Jarallax.js') }}"></script>
    <script src="{{ asset('assets/js/nice-select.js') }}"></script>
    <script src="{{ asset('assets/js/wow.min.js') }}"></script>
    <script src="{{ asset('assets/js/main.js') }}"></script>
    <script>
      // Get the current year
      const year = new Date().getFullYear();
      // Insert the year into the span with id "current-year"
      document.getElementById("current-year").textContent = year;
    </script>
    
<script>
document.addEventListener('DOMContentLoaded', function() {
  const form = document.getElementById('contact-form');
  const responseMessage = document.getElementById('response-message');
  const formContainer = document.querySelector('.contact-form-container');
  const formTitle = document.querySelector('.contact-form-container h3');
  const submitBtn = form.querySelector('button[type="submit"]');
  const submitText = submitBtn.querySelector('.submit-text');
  const spinner = submitBtn.querySelector('.spinner-border');

  // Real-time validation feedback
  form.querySelectorAll('.form-input').forEach(input => {
    input.addEventListener('input', function() {
      if (this.checkValidity()) {
        this.classList.remove('is-invalid');
        this.classList.add('is-valid');
      } else {
        this.classList.remove('is-valid');
      }
    });
    
    input.addEventListener('blur', function() {
      if (!this.checkValidity()) {
        this.classList.add('is-invalid');
      }
    });
  });

  form.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    // Validate all fields
    let isValid = true;
    form.querySelectorAll('.form-input').forEach(input => {
      if (!input.checkValidity()) {
        input.classList.add('is-invalid');
        isValid = false;
      }
    });

    if (!isValid) {
      return;
    }

    // Disable submit button and show spinner
    submitBtn.disabled = true;
    submitText.textContent = 'Processing...';
    spinner.classList.remove('d-none');

    // Hide form and show processing message
    form.style.display = 'none';
    formTitle.style.display = 'none';
    responseMessage.style.display = 'block';
    responseMessage.className = 'alert alert-info mt-3 text-center';
    responseMessage.textContent = 'Processing your request. Please wait...';

    try {
      const formData = new FormData(form);
      const response = await fetch(form.action, {
        method: 'POST',
        body: formData,
        headers: {
          'X-Requested-With': 'XMLHttpRequest',
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
      });

      const data = await response.json();

      if (!response.ok) {
        throw new Error(data.message || 'Network response was not ok');
      }

      if (data.status === 'success') {
        responseMessage.className = 'alert alert-success mt-3 text-center';
        responseMessage.innerHTML = `
          ${data.message || 'Ticket purchased successfully!'}
          <div class="mt-2">Redirecting to your ticket...</div>
        `;
        
        // Redirect to ticket page after 2 seconds
        setTimeout(() => {
          if (data.data?.ticket?.id) {
            window.location.href = `/get/ticket/${data.data.ticket.id}`;
          } else {
            window.location.reload();
          }
        }, 2000);
      } else {
        throw new Error(data.message || 'An error occurred. Please try again.');
      }
    } catch (error) {
      responseMessage.className = 'alert alert-danger mt-3 text-center';
      responseMessage.textContent = error.message;
      
      // Show form again after error
      setTimeout(() => {
        form.style.display = 'block';
        formTitle.style.display = 'block';
        responseMessage.style.display = 'none';
        
        // Reset button state
        submitBtn.disabled = false;
        submitText.textContent = 'Buy Ticket';
        spinner.classList.add('d-none');
      }, 3000);
    }
  });
});
</script>
      {{-- document.addEventListener('DOMContentLoaded', function() {
        // Remove sessionStorage related to ticketAmount since we don't need it anymore
        if (sessionStorage.getItem('ticketAmount')) {
          sessionStorage.removeItem('ticketAmount');
        }
      
        // Original form submission handler (unchanged)
        const form = document.getElementById('contact-form');
        const responseMessage = document.getElementById('response-message');
        const formContainer = document.querySelector('.contact-form-container');
        const formTitle = document.querySelector('.contact-form-container h3');
      
        // Add a flag to track if form is already being submitted
        let isSubmitting = false;

        // Kenyan phone validation regex: accepts +2547..., +2541..., 07..., 01..., 2547..., 2541...
        // function isValidKenyanPhone(phone) {
        //   const regex = /^(?:\+?254|0)?(7\d{8}|1\d{8})$/;
        //   return regex.test(phone);
        // }

        form.addEventListener('submit', function(e) {
          e.preventDefault();
          
          // Prevent multiple submissions
          if (isSubmitting) {
            return;
          }

          // // Validate phone number
          // const phoneInput = form.querySelector('input[name="phone"]');
          // if (!isValidKenyanPhone(phoneInput.value.trim())) {
          //   phoneInput.setCustomValidity('Please enter a valid Kenyan phone number (e.g., 0712345678, +254712345678, 0112345678, 254712345678).');
          //   form.reportValidity();
          //   phoneInput.setCustomValidity('');
          //   return;
          // }
      
          // Validate form fields
          if (!form.checkValidity()) {
            form.reportValidity();
            return;
          }

          // Prevent double submission by disabling the submit button
          const submitButton = form.querySelector('button[type="submit"]');
          if (submitButton.disabled) {
            return; // Already processing
          }
          
          // Set submission flag
          isSubmitting = true;
          
          submitButton.disabled = true;
          const originalButtonText = submitButton.textContent;
          submitButton.textContent = 'Processing...';
      
          // Store form data in case we need to restore it
          const formData = new FormData(form);
          const formDataObj = Object.fromEntries(formData.entries());
      
          // Hide form and title, show processing message
          form.style.display = 'none';
          formTitle.style.display = 'none';
          responseMessage.style.display = 'block';
          responseMessage.className = 'alert alert-info mt-3 text-center';
          responseMessage.textContent = 'Processing your request...';
      
          // Send AJAX request
          fetch('{{ route("buy-ticket") }}', {
            method: 'POST',
            body: formData,
            headers: {
              'X-Requested-With': 'XMLHttpRequest',
              'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
          })
          .then(response => {
            if (!response.ok) {
              throw new Error('Network response was not ok');
            }
            return response.json();
          })
          .then(data => {
            if (data.status === 'success' && !data.error) {
              // Show success message
              responseMessage.className = 'alert alert-success mt-3 text-center';
              responseMessage.textContent = data.message || 'Ticket purchased successfully!';
              
              // Only reload after everything is successful
              setTimeout(() => {
                window.location.reload();
              }, 2000);
            } else {
              // Show error message
              const errorMsg = data.message || data.error || 'An error occurred. Please try again.';
              responseMessage.className = 'alert alert-danger mt-3 text-center';
              responseMessage.textContent = errorMsg;
              
              // Re-enable submit button and restore form
              submitButton.disabled = false;
              submitButton.textContent = originalButtonText;
              isSubmitting = false;
              
              // Restore form data and show form again
              setTimeout(() => {
                Object.keys(formDataObj).forEach(key => {
                  const input = form.querySelector(`[name="${key}"]`);
                  if (input) {
                    if (input.type === 'select-one') {
                      input.value = formDataObj[key];
                    } else {
                      input.value = formDataObj[key];
                    }
                  }
                });
                
                form.style.display = 'block';
                formTitle.style.display = 'block';
                responseMessage.style.display = 'none';
              }, 3000);
            }
          })
          .catch(error => {
            // Re-enable submit button
            submitButton.disabled = false;
            submitButton.textContent = originalButtonText;
            isSubmitting = false;
            
            // Show error message
            responseMessage.className = 'alert alert-danger mt-3 text-center';
            responseMessage.textContent = 'An error occurred. Please try again.';
            
            // Restore form data and show form again
            setTimeout(() => {
              Object.keys(formDataObj).forEach(key => {
                const input = form.querySelector(`[name="${key}"]`);
                if (input) {
                  if (input.type === 'select-one') {
                    input.value = formDataObj[key];
                  } else {
                    input.value = formDataObj[key];
                  }
                }
              });
              
              form.style.display = 'block';
              formTitle.style.display = 'block';
              responseMessage.style.display = 'none';
            }, 3000);
            console.error('Error:', error);
          });
        });
      });
      </script>       --}}
    
    </body>
</html>
