<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Admin Register - OTP Authentication</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary-color: rgb(77, 11, 139);
            --secondary-color: rgb(117, 13, 143);
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --gray-color: #bebcbe;
        }
        
        body {
            background-color: #f5f5f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        
        .login-container {
            max-width: 1200px;
            margin: 0 auto;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            background-color: white;
        }
        
        .login-card {
            border: none;
            border-radius: 10px;
        }
        
        .login-header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 1.5rem;
            text-align: center;
        }
        
        .login-title {
            font-weight: 700;
            letter-spacing: 1px;
            margin-bottom: 0;
        }
        
        .form-label {
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 0.5rem;
        }
        
        .btn-primary-custom {
            background-color: var(--secondary-color);
            border: none;
            padding: 12px;
            font-weight: 600;
            transition: all 0.3s ease;
            width: 100%;
        }
        
        .btn-primary-custom:hover {
            background-color: var(--primary-color);
            transform: translateY(-2px);
        }
        
        .btn-outline-primary-custom {
            color: var(--secondary-color);
            border-color: var(--secondary-color);
            font-weight: 600;
            padding: 10px 15px;
        }
        
        .btn-outline-primary-custom:hover {
            background-color: var(--secondary-color);
            color: white;
        }
        
        .input-group-text {
            background-color: white;
            border-right: none;
        }
        
        .form-control {
            border-left: none;
        }
        
        .login-footer {
            text-align: center;
            margin-top: 1.5rem;
            font-size: 0.9rem;
        }
        
        .login-footer a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s ease;
        }
        
        .login-footer a:hover {
            color: var(--secondary-color);
            text-decoration: underline;
        }
        
        .logo-container {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100%;
            padding: 2rem;
            background-color: rgba(255, 255, 255, 0.9);
        }
        
        .logo-img {
            max-width: 100%;
            height: auto;
            transition: transform 0.3s ease;
        }
        
        .logo-img:hover {
            transform: scale(1.05);
        }
        
        /* Animation for OTP input (not used here but kept for consistency) */
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.02); }
            100% { transform: scale(1); }
        }
        
        /* Responsive adjustments */
        @media (max-width: 992px) {
            .logo-container {
                padding: 1.5rem;
            }
            .login-container {
                margin: 1rem;
            }
        }
        
        @media (max-width: 768px) {
            .login-container {
                margin: 0.5rem;
                border-radius: 10px;
            }
            .logo-container {
                padding: 1rem;
            }
            .login-header {
                padding: 1rem;
            }
            .login-title {
                font-size: 1.5rem;
            }
        }
        
        /* Notification styling */
        .notification-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
            width: 100%;
            max-width: 350px;
        }
        
        .alert {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border: none;
        }
        
        /* Form input styling */
        .form-section {
            padding: 2rem;
        }
        
        .input-field {
            margin-bottom: 1.5rem;
        }
        
        .action-buttons {
            margin-top: 2rem;
        }
        
        /* Phone input container */
        .phone-input-container {
            display: flex;
            gap: 10px;
        }
        
        .phone-input {
            flex: 1;
        }
        
        @media (max-width: 576px) {
            .phone-input-container {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <!-- Notification Container -->
    <div class="notification-container"></div>
    
    <div class="login-container">
        <div class="row g-0">
            <!-- Logo Section -->
            <div class="col-lg-5 d-flex align-items-center">
                <div class="logo-container">
                    <img src="{{ asset('assets/img/logo/logo.png') }}" alt="Company Logo" class="logo-img">
                </div>
            </div>
            
            <!-- Form Section -->
            <div class="col-lg-7">
                <div class="login-card h-100">
                    <div class="login-header">
                        <h2 class="login-title">ADMIN REGISTER</h2>
                    </div>
                    
                    <div class="form-section">
                        <!-- Session Status -->
                        @if (session('status'))
                            <div class="mb-4 alert alert-success bg-success">
                                {{ session('status') }}
                            </div>
                        @endif
                        
                        <!-- Validation Errors -->
                        @if ($errors->any())
                            <div class="mb-4 alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        
                        <form method="POST" action="{{ route('register') }}">
                            @csrf

                            <!-- Name -->
                            <div class="input-field">
                                <label for="name" class="form-label">
                                    <i class="fas fa-user me-2"></i> {{ __('Name') }}
                                </label>
                                <x-text-input id="name" class="form-control form-control-lg" type="text" name="name" :value="old('name')" required autofocus autocomplete="name" />
                                <x-input-error :messages="$errors->get('name')" class="mt-2" />
                            </div>

                            <!-- Phone Number (Required) -->
                            <div class="input-field">
                                <label for="phone" class="form-label">
                                    <i class="fas fa-mobile-alt me-2"></i> {{ __('Phone Number') }}
                                </label>
                                <div class="phone-input-container">
                                    <div class="input-group phone-input">
                                        <span class="input-group-text">
                                            <i class="fas fa-phone"></i>
                                        </span>
                                        <x-text-input id="phone" class="form-control form-control-lg" type="tel" name="phone" :value="old('phone')" required autocomplete="tel" />
                                    </div>
                                </div>
                                <x-input-error :messages="$errors->get('phone')" class="mt-2" />
                                <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                                    {{ __('Your phone number will be used for login and verification') }}
                                </p>
                            </div>

                            <!-- Email Address (Optional) -->
                            <div class="input-field">
                                <label for="email" class="form-label">
                                    <i class="fas fa-envelope me-2"></i> {{ __('Email (Optional)') }}
                                </label>
                                <x-text-input id="email" class="form-control form-control-lg" type="email" name="email" :value="old('email')" autocomplete="email" />
                                <x-input-error :messages="$errors->get('email')" class="mt-2" />
                                <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                                    {{ __('Email is optional for account recovery and notifications') }}
                                </p>
                            </div>

                            <!-- Password -->
                            <div class="input-field">
                                <label for="password" class="form-label">
                                    <i class="fas fa-lock me-2"></i> {{ __('Password') }}
                                </label>
                                <x-text-input id="password" class="form-control form-control-lg" type="password" name="password" required autocomplete="new-password" />
                                <x-input-error :messages="$errors->get('password')" class="mt-2" />
                            </div>

                            <!-- Confirm Password -->
                            <div class="input-field">
                                <label for="password_confirmation" class="form-label">
                                    <i class="fas fa-lock me-2"></i> {{ __('Confirm Password') }}
                                </label>
                                <x-text-input id="password_confirmation" class="form-control form-control-lg" type="password" name="password_confirmation" required autocomplete="new-password" />
                                <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
                            </div>

                            <!-- Role Information -->
                            <div class="p-4 mt-4 rounded-lg bg-blue-50 dark:bg-blue-900/20">
                                <p class="text-sm text-blue-800 dark:text-blue-300">
                                    <strong>{{ __('Note:') }}</strong> 
                                    {{ __('All new accounts are automatically assigned the Customer Support role with appropriate permissions.') }}
                                </p>
                            </div>

                            <div class="action-buttons">
                                <x-primary-button class="btn btn-primary-custom btn-lg">
                                    <i class="fas fa-user-plus me-2"></i> {{ __('Register') }}
                                </x-primary-button>
                            </div>

                            <!-- Footer Links -->
                            <div class="login-footer">
                                <p class="mb-2">Already registered? 
                                    <a href="{{ route('login') }}">
                                        <i class="fas fa-sign-in-alt me-1"></i> {{ __('Login here') }}
                                    </a>
                                </p>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>