<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <meta name="description" content="PACE Events" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <!-- Primary Meta Tags -->
        <meta name="title" content="PACE" />
        <meta name="description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
    
        <!-- Open Graph / Facebook -->
        <meta property="og:type" content="website" />
        <meta property="og:url" content="https://pace-gules.vercel.app/" />
        <meta property="og:title" content="PACE" />
        <meta property="og:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="og:image" content="https://events.pacesetter.co.ke/assets/img/logo/logo.png" />
    
        <!-- Twitter -->
        <meta property="twitter:card" content="summary_large_image" />
        <meta property="twitter:url" content="https://pace-gules.vercel.app/" />
        <meta property="twitter:title" content="PACE" />
        <meta property="twitter:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="twitter:image" content="https://events.pacesetter.co.ke/assets/img/logo/logo.png" />
    
    
        <link
          rel="shortcut icon"
          type="image/x-icon"
          href="assets/img/logo/logo.png"
        />
        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

         <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])

        <style>
                    /* Main Container Styles */
            .tickets-container {
                max-width: 100%;
                margin: 0 auto;
                padding: 1.5rem;
                overflow-x: auto;
            }

            /* Stats Cards */
            .stats-card {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                border-radius: 10px;
                padding: 1.5rem;
                margin-bottom: 2rem;
                text-align: center;
                min-width: 200px;
            }

            .stats-card.success {
                background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
            }

            .stats-card.warning {
                background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            }

            .stats-card.info {
                background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            }

            .stats-card.danger {
                background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
            }

            /* Buttons */
            .btn-primary {
                background-color: #6c04f5;
                border-color: #6c04f5;
            }

            .btn-primary:hover {
                background-color: #5a03d1;
                border-color: #5a03d1;
            }

            /* Search Filters */
            .search-filters {
                background: #f8f9fa;
                border-radius: 10px;
                padding: 1.5rem;
                margin-bottom: 2rem;
                min-width: 1200px;
            }

            /* Table Container */
            /* Update the table container styles */
            .table-responsive-container {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
            margin: 0 2rem; /* Increased from 1rem to 2rem */
            background: white;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            min-width: 100%;
            }

            /* Update the table width to be auto */
            .table {
            width: auto; /* Changed from 100% to auto */
            min-width: 100%; /* Changed from fixed width to 100% */
            margin-bottom: 0;
            }

            /* Add more padding to the container */
            .tickets-container {
                max-width: 100%;
                margin: 0 auto;
                padding: 1.5rem 2rem; /* Added right/left padding */
                overflow-x: auto;
            }

            /* Update scrollbar styling */
            .table-responsive-container::-webkit-scrollbar {
                height: 10px; /* Increased from 8px */
            }

            .table-responsive-container::-webkit-scrollbar-track {
                background: #f8f9fa;
                border-radius: 5px;
            }

            .table-responsive-container::-webkit-scrollbar-thumb {
                background: #6c04f5;
                border-radius: 5px;
            }

            .table-responsive-container::-webkit-scrollbar-thumb:hover {
                background: #5a03d1;
            }
            .scrollable-contact,
            .scrollable-payment-date {
            max-width: 200px;
            overflow-x: auto;
            white-space: nowrap;
            padding-right: 5px;
            }

            /* Custom Scrollbars for scrollable columns */
            .scrollable-contact::-webkit-scrollbar,
            .scrollable-payment-date::-webkit-scrollbar {
            height: 4px;
            }

            .scrollable-contact::-webkit-scrollbar-thumb,
            .scrollable-payment-date::-webkit-scrollbar-thumb {
            background: #6c04f5;
            border-radius: 2px;
            }
            .table th {
                background-color: #6c04f5;
                color: white;
                border: none;
                font-weight: 600;
                padding: 0.75rem;
                position: sticky;
                top: 0;
                z-index: 10;
                white-space: nowrap;
            }

            .table td {
                vertical-align: middle;
                padding: 0.75rem;
                white-space: nowrap;
            }

            /* Column Specific Styles */
            .table th:nth-child(1), .table td:nth-child(1) { /* ID */
            width: 60px;
            min-width: 60px;
            }

            .table th:nth-child(6), .table td:nth-child(6) { /* Qty */
            width: 70px;
            min-width: 70px;
            text-align: center;
            }

            /* Status Badges */
            .status-badge {
                font-size: 0.75rem;
                padding: 0.25rem 0.5rem;
                border-radius: 0.25rem;
                display: inline-block;
                white-space: nowrap;
            }

            .status-completed {
                background-color: #28a745;
                color: white;
            }

            .status-pending {
                background-color: #ffc107;
                color: #212529;
            }

            .status-failed {
                background-color: #dc3545;
                color: white;
            }

            .stk-status-success {
                background-color: #28a745;
                color: white;
            }

            .stk-status-pending {
                background-color: #ffc107;
                color: #212529;
            }

            .stk-status-failed {
                background-color: #dc3545;
                color: white;
            }

            .stk-status-insufficient {
                background-color: #fd7e14;
                color: white;
            }

            .stk-status-canceled {
                background-color: #ffc107;
                color: #212529;
            }

            .stk-status-timeout {
                background-color: #fd7e14;
                color: white;
            }

            .stk-status-invalid-input {
                background-color: #ffc107;
                color: #212529;
            }

            /* Special Elements */
            .ticket-reference {
                font-family: 'Courier New', monospace;
                font-size: 0.85rem;
                background-color: #f8f9fa;
                padding: 0.25rem 0.5rem;
                border-radius: 0.25rem;
                white-space: nowrap;
            }

            .amount-display {
                font-weight: 600;
                color: #28a745;
                white-space: nowrap;
            }

            .school-badge {
                font-size: 0.7rem;
                padding: 0.25rem 0.5rem;
                border-radius: 0.25rem;
                background-color: #6c757d;
                color: white;
                display: inline-block;
                white-space: nowrap;
            }

            /* Pagination */
            .pagination {
                --bs-pagination-padding-x: 0.75rem;
                --bs-pagination-padding-y: 0.375rem;
                --bs-pagination-font-size: 0.875rem;
                --bs-pagination-color: #6c04f5;
                --bs-pagination-bg: #fff;
                --bs-pagination-border-width: 1px;
                --bs-pagination-border-color: #dee2e6;
                --bs-pagination-border-radius: 0.375rem;
                --bs-pagination-hover-color: #5a03d1;
                --bs-pagination-hover-bg: #f8f9ff;
                --bs-pagination-hover-border-color: #6c04f5;
                --bs-pagination-focus-color: #5a03d1;
                --bs-pagination-focus-bg: #f8f9ff;
                --bs-pagination-focus-box-shadow: 0 0 0 0.25rem rgba(108, 4, 245, 0.25);
                --bs-pagination-active-color: #fff;
                --bs-pagination-active-bg: #6c04f5;
                --bs-pagination-active-border-color: #6c04f5;
                --bs-pagination-disabled-color: #6c757d;
                --bs-pagination-disabled-bg: #fff;
                --bs-pagination-disabled-border-color: #dee2e6;
            }

            .pagination .page-link {
                border-radius: 0.375rem !important;
                margin: 0 0.125rem;
            }

            /* DataTables Custom Styling */
            .dataTables_wrapper {
                margin: 0.5rem 0;
                min-width: 100%;
            }

            .dataTables_wrapper .dataTables_length,
            .dataTables_wrapper .dataTables_filter,
            .dataTables_wrapper .dataTables_info,
            .dataTables_wrapper .dataTables_paginate {
                padding: 0.75rem;
                background-color: #f8f9fa;
                border-radius: 0.5rem;
                margin: 0.5rem 0;
                white-space: nowrap;
            }

            .dataTables_wrapper .dataTables_length select,
            .dataTables_wrapper .dataTables_filter input {
                border: 1px solid #dee2e6;
                border-radius: 0.375rem;
                padding: 0.375rem 0.75rem;
            }

            .dataTables_wrapper .dataTables_paginate {
                text-align: center;
                float: none;
            }

            .dataTables_wrapper .dataTables_paginate .paginate_button {
                border-radius: 0.375rem !important;
                margin: 0 0.125rem;
                border: 1px solid #dee2e6;
                padding: 0.375rem 0.75rem !important;
            }

            .dataTables_wrapper .dataTables_paginate .paginate_button.current {
                background: #6c04f5 !important;
                border-color: #6c04f5 !important;
                color: white !important;
            }

            .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
                background: #5a03d1 !important;
                border-color: #5a03d1 !important;
                color: white !important;
            }

            /* Scrollbar Styling */
            .table-responsive-container::-webkit-scrollbar {
                height: 8px;
            }

            .table-responsive-container::-webkit-scrollbar-track {
                background: #f8f9fa;
                border-radius: 4px;
            }

            .table-responsive-container::-webkit-scrollbar-thumb {
                background: #6c04f5;
                border-radius: 4px;
            }

            .table-responsive-container::-webkit-scrollbar-thumb:hover {
                background: #5a03d1;
            }
            .table th {
            position: sticky;
            top: 0;
            background-color: #6c04f5;
            color: white;
            white-space: nowrap;
            }

            /* Responsive Adjustments */
            @media (max-width: 1400px) {
                .tickets-container {
                    padding: 1rem;
                    overflow-x: auto;
                }
                
                .search-filters {
                    min-width: 1000px;
                }
                
                .table {
                    min-width: 1000px;
                }
            }

            @media (max-width: 1200px) {
                .tickets-container {
                    padding: 1rem;
                }
                
                .stats-card {
                    padding: 1rem;
                    margin-bottom: 1rem;
                    min-width: 150px;
                }
                
                .search-filters {
                    padding: 1rem;
                    min-width: 900px;
                }
                
                .table {
                    min-width: 900px;
                }
            }

            @media (max-width: 992px) {
                .stats-card {
                    min-width: 120px;
                }
                
                .search-filters {
                    min-width: 800px;
                }
                
                .table {
                    min-width: 800px;
                    font-size: 0.85rem;
                }
                
                .scrollable-contact,
                .scrollable-payment-date {
                    max-width: 150px;
                }
            }

            @media (max-width: 768px) {
                .tickets-container {
                    padding: 0.75rem;
                }
                
                .stats-card {
                    min-width: 100px;
                    padding: 0.75rem;
                }
                
                .search-filters {
                    min-width: 700px;
                    padding: 0.75rem;
                }
                
                .table {
                    min-width: 700px;
                    font-size: 0.8rem;
                }
                
                .table th,
                .table td {
                    padding: 0.5rem;
                }
                
                .dataTables_wrapper .dataTables_length,
                .dataTables_wrapper .dataTables_filter,
                .dataTables_wrapper .dataTables_info,
                .dataTables_wrapper .dataTables_paginate {
                    padding: 0.5rem;
                }
                
                .scrollable-contact,
                .scrollable-payment-date {
                    max-width: 120px;
                }
                
                .btn-group {
                    width: 100%;
                    flex-wrap: wrap;
                }
                
                .btn-group .btn {
                    margin-bottom: 0.5rem;
                    flex: 1 0 auto;
                }
            }

            @media (max-width: 576px) {
                .tickets-container {
                    padding: 0.5rem;
                }
                
                .stats-card {
                    min-width: 80px;
                    padding: 0.5rem;
                }
                
                .search-filters {
                    min-width: 600px;
                    padding: 0.5rem;
                }
                
                .table {
                    min-width: 600px;
                    font-size: 0.75rem;
                }
                
                .table th,
                .table td {
                    padding: 0.4rem;
                }
                
                .ticket-reference,
                .status-badge,
                .school-badge {
                    font-size: 0.7rem;
                }
                
                .dataTables_wrapper .dataTables_paginate .paginate_button {
                    padding: 0.25rem 0.5rem !important;
                    margin: 0 0.1rem !important;
                }
                
                .scrollable-contact,
                .scrollable-payment-date {
                    max-width: 100px;
                }
            }

            /* Hover Effects */
            .table tbody tr:hover {
                background-color: rgba(108, 4, 245, 0.05);
            }

            /* Text Alignment Helpers */
            .text-center {
                text-align: center !important;
            }

            .text-end {
                text-align: right !important;
            }

            .text-start {
                text-align: left !important;
            }

            /* Navigation Row */
            .navigation-row {
                min-width: 100%;
                display: flex;
                flex-wrap: nowrap;
                overflow-x: auto;
            }

            /* Stats Row */
            .stats-row {
                min-width: 100%;
                display: flex;
                flex-wrap: nowrap;
                overflow-x: auto;
            }

            /* Stats Column */
            .stats-col {
                flex: 0 0 auto;
                padding-right: 15px;
                padding-left: 15px;
            }

            /* Force horizontal scroll on smaller screens */
            @media (max-width: 1200px) {
                .stats-row,
                .navigation-row {
                    flex-wrap: nowrap;
                    overflow-x: auto;
                    -webkit-overflow-scrolling: touch;
                }
                
                .stats-col {
                    flex: 0 0 auto;
                }
            }
            </style>

    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-gray-100 dark:bg-gray-900">
            @include('layouts.navigation')

            <!-- Page Heading -->
            @isset($header)
                <header class="bg-white dark:bg-gray-800 shadow">
                    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                        {{ $header }}
                    </div>
                </header>
            @endisset

            <!-- Page Content -->
            <main>
                {{ $slot }}
            </main>
        </div>
    </body>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
</html>
