<style>
/* Navigation Custom Styles */
.nav-buttons-container {
    display: flex;
    align-items: center;
    gap: 1.5rem;
    margin-left: 3rem;
    flex-wrap: nowrap;
    overflow-x: auto;
    padding-bottom: 0.25rem;
}

.nav-button {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 0.5rem 1rem;
    font-size: 0.9rem;
    font-weight: 500;
    text-decoration: none;
    border-radius: 0.375rem;
    
    background: white;
    color: #374151;
    transition: all 0.15s ease-in-out;
    white-space: nowrap;
    flex-shrink: 0;
    min-width: fit-content;
}

.nav-button:hover {
    background: #f9fafb;
    color: #111827;
    border-color: #d1d5db;
    transform: translateY(-1px);
}

.nav-button:focus {
    outline: none;
    ring: 2px;
    ring-color: rgba(108, 4, 245, 0.2);
    border-color: #6c04f5;
}

/* Dark mode styles */
.dark .nav-button {
    background: #1f2937;
    color: #d1d5db;
    border-color: #374151;
}

.dark .nav-button:hover {
    background: #374151;
    color: #f9fafb;
    border-color: #4b5563;
}

/* Active state for users button */
.dark .nav-button.active {
    background: #6c04f5;
    color: white;
    border-color: #6c04f5;
}

/* Mobile navigation styles */
.mobile-nav-buttons {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
    padding: 1rem 0;
}

.mobile-nav-button {
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0.75rem 1rem;
    font-size: 0.9rem;
    font-weight: 500;
    text-decoration: none;
    border-radius: 0.375rem;
    
    background: white;
    color: #374151;
    transition: all 0.15s ease-in-out;
    width: 100%;
}

.mobile-nav-button:hover {
    background: #f9fafb;
    color: #111827;
    border-color: #d1d5db;
}

.dark .mobile-nav-button {
    background: #1f2937;
    color: #d1d5db;
    border-color: #374151;
}

.dark .mobile-nav-button:hover {
    background: #374151;
    color: #f9fafb;
    border-color: #4b5563;
}

.mobile-nav-button.active {
    background: #6c04f5;
    color: white;
    border-color: #6c04f5;
}

.dark .mobile-nav-button.active {
    background: #6c04f5;
    color: white;
    border-color: #6c04f5;
}

/* Scrollbar styling for horizontal nav buttons */
.nav-buttons-container::-webkit-scrollbar {
    height: 4px;
}

.nav-buttons-container::-webkit-scrollbar-track {
    background: #f1f5f9;
    border-radius: 2px;
}

.nav-buttons-container::-webkit-scrollbar-thumb {
    background: #cbd5e1;
    border-radius: 2px;
}

.nav-buttons-container::-webkit-scrollbar-thumb:hover {
    background: #94a3b8;
}

.dark .nav-buttons-container::-webkit-scrollbar-track {
    background: #374151;
}

.dark .nav-buttons-container::-webkit-scrollbar-thumb {
    background: #4b5563;
}

.dark .nav-buttons-container::-webkit-scrollbar-thumb:hover {
    background: #6b7280;
}

/* Responsive adjustments */
@media (max-width: 1400px) {
    .nav-buttons-container {
        margin-left: 2rem;
        gap: 1.25rem;
    }
    
    .nav-button {
        padding: 0.5rem 0.875rem;
        font-size: 0.85rem;
    }
}

@media (max-width: 1200px) {
    .nav-buttons-container {
        margin-left: 1.5rem;
        gap: 1rem;
        max-width: 200px;
    }
    
    .nav-button {
        padding: 0.5rem 0.75rem;
        font-size: 0.8rem;
    }
}

@media (max-width: 1024px) {
    .nav-buttons-container {
        max-width: 400px;
        gap: 0.875rem;
    }
}

@media (max-width: 768px) {
    .nav-buttons-container {
        display: none;
    }
}

/* Ensure proper spacing in the main nav */
.hidden.sm\:flex {
    align-items: center;
}

/* Fix for the dashboard link spacing */
.space-x-8.sm\:-my-px.sm\:ms-10.sm\:flex {
    align-items: center;
}

/* Smooth transitions */
.nav-button, .mobile-nav-button {
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
}

/* Focus states for accessibility */
.nav-button:focus-visible,
.mobile-nav-button:focus-visible {
    outline: 2px solid #6c04f5;
    outline-offset: 2px;
}

/* Even spacing distribution */
@media (min-width: 769px) {
    .nav-buttons-container {
        justify-content: space-between;
        flex: 1;
        margin-left: 2rem;
        margin-right: 2rem;
    }
}
</style>
<nav x-data="{ open: false }" class="bg-white border-b border-gray-100 dark:bg-gray-800 dark:border-gray-700">
    <!-- Primary Navigation Menu -->
    <div class="px-4 mx-auto max-w-7xl sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <!-- Logo -->
                <div class="flex items-center shrink-0">
                    <a href="{{ route('dashboard') }}">
                        <img src="{{ asset('assets/img/logo/logo.png') }}" alt="Logo" class="w-auto h-8">
                    </a>
                </div>

                <!-- Navigation Links -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')" style="color: rgb(94, 5, 112);font-size:30px;" class="text-uppercase">
                        {{ __('Dashboard') }}
                    </x-nav-link>
                    
                    <!-- Navigation Buttons Container -->
                    <div class="nav-buttons-container">
                        @role('super-admin|admin')
                        <a href="{{ route('users.index') }}" class="nav-button">
                            Users
                        </a>
                        @endrole
                        
                        <a href="{{ route('tickets.index') }}" class="nav-button">
                            All Tickets
                        </a>
                        
                        @can('view-metrics')
                        <a href="{{ route('tickets.analytics') }}" class="nav-button">
                            Analytics
                        </a>
                        @endcan
                        
                        @can('access-messages')
                        <a href="{{ route('sms.index') }}" class="nav-button">
                            SMS Manager
                        </a>
                        @endcan
                        
                        @can('access-complimentary')
                        <a href="{{ route('complimentary.tickets.index') }}" class="nav-button">
                            Complimentary
                        </a>
                        <a href="{{ route('csv.index') }}" class="nav-button">
                            CSV Processor
                        </a>
                        @endcan
                        
                        {{-- @can('manage-contacts')
                        <a href="{{ route('contacts.import.form') }}" class="nav-button">
                            Contacts
                        </a>
                        @endcan --}}
                    </div>
                </div>
            </div>

            <!-- Settings Dropdown -->
            <div class="hidden sm:flex sm:items-center sm:ms-6">
                <x-dropdown align="right" width="48">
                    <x-slot name="trigger">
                        <button class="inline-flex items-center px-3 py-2 text-sm font-medium leading-4 text-gray-900 transition duration-150 ease-in-out bg-white border border-transparent rounded-md dark:text-gray-900 dark:bg-gray-900 hover:text-gray-900 dark:hover:text-gray-900 focus:outline-none">
                            <div>{{ Auth::user()->name }}</div>

                            <div class="ms-1">
                                <svg class="w-4 h-4 fill-current" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </div>
                        </button>
                    </x-slot>

                    <x-slot name="content">
                        <x-dropdown-link :href="route('profile.edit')">
                            {{ __('Profile') }}
                        </x-dropdown-link>

                        <!-- Authentication -->
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf

                            <x-dropdown-link :href="route('logout')"
                                    onclick="event.preventDefault();
                                                this.closest('form').submit();">
                                {{ __('Log Out') }}
                            </x-dropdown-link>
                        </form>
                    </x-slot>
                </x-dropdown>
            </div>

            <!-- Hamburger -->
            <div class="flex items-center -me-2 sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 text-gray-400 transition duration-150 ease-in-out rounded-md dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-900 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-900 focus:text-gray-500 dark:focus:text-gray-400">
                    <svg class="w-6 h-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            <x-responsive-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')" style="color: rgb(94, 5, 112);">
                {{ __('Admin Dashboard') }}
            </x-responsive-nav-link>
            
            
            <!-- Mobile Navigation Buttons -->
                <div class="mobile-nav-buttons">
                    @role('super-admin|admin')
                    <a href="{{ route('users.index') }}" class="mobile-nav-button">
                        Users
                    </a>
                    @endrole
                    
                    <a href="{{ route('tickets.index') }}" class="mobile-nav-button">
                        All Tickets
                    </a>
                    
                    @can('view-metrics')
                    <a href="{{ route('tickets.analytics') }}" class="mobile-nav-button">
                        Analytics
                    </a>
                    @endcan
                    
                    @can('access-messages')
                    <a href="{{ route('sms.index') }}" class="mobile-nav-button">
                        SMS Manager
                    </a>
                    @endcan
                    
                    @can('access-complimentary')
                    <a href="{{ route('complimentary.tickets.index') }}" class="mobile-nav-button">
                        Complimentary Tickets
                    </a>
                    <a href="{{ route('csv.index') }}" class="mobile-nav-button">
                        CSV Processor
                    </a>
                    @endcan
                    @can('manage-contacts')
                    <a href="{{ route('contacts.import.form') }}" class="mobile-nav-button">
                        Manage Contacts
                    </a>
                    @endcan
                    
                </div>
        </div>

        <!-- Responsive Settings Options -->
        <div class="pt-4 pb-1 border-t border-gray-200 dark:border-gray-600">
            <div class="px-4">
                <div class="text-base font-medium text-gray-800 dark:text-gray-200">{{ Auth::user()->name }}</div>
                <div class="text-sm font-medium text-gray-500">{{ Auth::user()->email }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('profile.edit')">
                    {{ __('Profile') }}
                </x-responsive-nav-link>

                <!-- Authentication -->
                <form method="POST" action="{{ route('logout') }}">
                    @csrf

                    <x-responsive-nav-link :href="route('logout')"
                            onclick="event.preventDefault();
                                        this.closest('form').submit();">
                        {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </form>
            </div>
        </div>
    </div>
</nav>