<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Verify Ticket by Phone Number</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.11.3/font/bootstrap-icons.min.css" rel="stylesheet"/>
    <style>
        :root {
            --card-bg: #ffffff;
            --text-dark: #212529;
            --accent: #ff7f45;
            --divider: rgba(0,0,0,0.075);
        }
        body{
            background:#f8f9fa;
            color: var(--text-dark);
            font-family: "Inter", sans-serif;
        }
        .ticket-wrapper{
            max-width: 420px;
            margin: 2rem auto;
            padding: 0 1rem;
        }
        .ticket-card{
            background: var(--card-bg);
            border-radius: 1rem;
            overflow:hidden;
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,.15);
            width: 100%;
            max-width: 100%;
        }
        .ticket-content{
            display: flex;
            align-items: center;
            min-height: 200px;
        }
        .ticket-left{
            flex: 1;
            padding: 1.5rem;
        }
        .ticket-right{
            flex: 0 0 200px;
            padding: 1.5rem;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            background: #f8f9fa;
            border-left: 1px dashed var(--divider);
        }
        @media (max-width: 768px) {
            .ticket-content {
                flex-direction: column;
                min-height: auto;
            }
            .ticket-left {
                padding: 1rem;
            }
            .ticket-right {
                flex: none;
                width: 100%;
                border-left: none;
                border-top: 1px dashed var(--divider);
                padding: 1rem;
            }
        }
        .event-header{
            display: flex;
            gap: 1rem;
            align-items: center;
            margin-bottom: 1rem;
        }
        .event-header img{
            width: 60px;
            height: 60px;
            object-fit: cover;
            border-radius: .5rem;
            flex-shrink: 0;
        }
        .event-info {
            flex: 1;
        }
        .event-info h5 {
            margin: 0 0 0.25rem 0;
            font-size: 1.1rem;
        }
        .event-info small {
            display: block;
            margin-bottom: 0.25rem;
        }
        .chip{
            font-size:.7rem;
            background:#e9ecef;
            color:#6c757d;
            padding:.2rem .6rem;
            border-radius:999px;
            text-transform:uppercase;
            letter-spacing:.05em;
        }
        .divider{
            border-top:1px dashed var(--divider);
            margin:0 1rem;
        }
        .details-table td{
            padding:.25rem 0;
        }
        .copy-btn{
            cursor:pointer;
        }
        .btn-verify{
            border-radius:2rem;
            font-weight:600;
            letter-spacing:.03em;
            background: var(--accent);
            border:none;
            color:#fff;
            padding:.5rem 1.25rem;
        }
        .status{margin-top:1rem;padding:1rem;border-radius:.75rem;font-size:.875rem}
        .status.success{background:#ECFDF5;color:#065F46;border:1px solid #D1FAE5}
        .status.danger{background:#FEF2F2;color:#7F1D1D;border:1px solid #FEE2E2}
        .status.warn{background:#FFFBEB;color:#78350F;border:1px solid #FDE68A}
        /* Ticket Summary */
        .ticket-summary{background:#fff;border:1px solid var(--divider);border-radius:.75rem;padding:1rem;margin-bottom:1rem}
        .summary-row{display:flex;justify-content:space-between;align-items:center;padding:.5rem 0;border-bottom:1px solid #f1f3f5}
        .summary-row:last-child{border-bottom:none}
        .summary-label{font-size:.75rem;color:#6c757d;text-transform:uppercase;letter-spacing:.03em}
        .summary-value{font-size:.95rem;color:#212529;font-weight:600}

        /* Per-Unit List */
        .unit-list{display:flex;flex-direction:column;gap:.75rem}
        .unit-item{
            position:relative;
            display:flex;
            justify-content:space-between;
            align-items:center;
            padding:15px 25px;
            background:#fef3c7;
            background-image:
                radial-gradient(ellipse closest-side at 50% 50%,hsla(0,0%,100%,.1),transparent 90%),
                radial-gradient(circle at 0 100%,transparent 10px,#ffffff 11px),
                radial-gradient(circle at 100% 100%,transparent 10px,#ffffff 11px),
                radial-gradient(circle at 100% 0,transparent 10px,#ffffff 11px),
                radial-gradient(circle at 0 0,transparent 10px,#ffffff 11px);
            background-position:center center,bottom left,bottom right,top right,top left;
            background-size:cover,51% 51%,51% 51%,51% 51%,51% 51%;
            background-repeat:no-repeat;
            border:0 solid transparent;
            border-image:radial-gradient(cover circle,#ffffff 0%,#ffffff 50%,transparent 51%) 0 39%/11px 4px repeat;
            border-radius:5px;
            box-shadow:0 2px 4px rgba(0,0,0,.15);
        }
        .unit-info{display:flex;flex-direction:column;z-index:1}
        .unit-label{font-size:1.05rem;color:#111827;font-weight:700;margin-bottom:.2rem}
        .unit-status{font-size:.7rem;font-weight:600;padding:.25rem .55rem;border-radius:999px;letter-spacing:.02em}
        .unit-status.verified{background:#d1fae5;color:#065f46}
        .unit-status.pending{background:#f3f4f6;color:#6b7280}
        .btn-verify-unit{
            position:relative;
            z-index:1;
            padding:.45rem .9rem;
            font-size:.8rem;
            font-weight:700;
            border-radius:999px;
            background:#111827;
            color:#fff;
            border:none;
            letter-spacing:.03em;
            box-shadow:0 1px 2px rgba(0,0,0,.2);
            transition:transform .12s ease;
        }
        .btn-verify-unit:active{transform:scale(.96)}
        .avatar{width:48px;height:48px;border-radius:999px;background:var(--accent);color:#fff;display:flex;align-items:center;justify-content:center;font-weight:600;font-size:1.1rem}
        .header{display:flex;align-items:center;gap:1rem;margin-bottom:1rem}
        .title{font-size:1.1rem;margin:0;color:var(--text-dark)}
        .muted{color:#6c757d;font-size:.875rem}
        .form-row{display:flex;gap:.5rem;margin-top:.75rem;width:100%}
        input[type="text"], input[type="tel"]{
            flex:1;
            padding:.75rem 1rem;
            border:1px solid #dee2e6;
            border-radius:.5rem;
            font-size:1.1rem;
            min-width:0;
            width:100%;
        }
        .btn-search{
            border-radius:2rem;
            font-weight:600;
            letter-spacing:.03em;
            background: var(--accent);
            border:none;
            color:#fff;
            padding:.75rem 1.5rem;
            cursor:pointer;
            flex-shrink:0;
            white-space:nowrap;
        }
    </style>
</head>
<body>
<div class="ticket-wrapper">
    <div class="ticket-card">
        <div class="ticket-content">
            <div class="ticket-left">
                <div class="event-header">
                    <div class="avatar">{{ isset($user) && $user ? strtoupper(substr($user->name ?? 'U',0,1)) : 'U' }}</div>
                    <div class="event-info">
                        <div class="title">Verify Ticket by Phone</div>
                        <div class="muted">Signed in as {{ isset($user) && $user ? ($user->name ?? $user->email) : 'User' }}</div>
                    </div>
                </div>
                <div class="muted">Enter the phone number used to purchase the ticket (e.g., 0712345678 or 254712345678).</div>
                <form method="GET" action="{{ route('gate.ticket.verify.show.number') }}" class="form" id="verifyForm" style="width:100%">
                    <div class="form-row">
                        <input type="tel" name="phone" id="phoneInput" value="{{ $phone ?? '' }}" placeholder="Phone number" autocomplete="off" autofocus>
                        <button type="submit" class="btn-search">Search</button>
                    </div>
                </form>

                @if(isset($error) && $error)
                    <div class="status danger mt-3">{{ $error }}</div>
                @endif

                @if(isset($ticket) && $ticket)
                    <div class="mt-3 text-center">
                        @if(isset($ticket->is_complimentary) && $ticket->is_complimentary)
                            @if($ticket->ticket_type === 'vip')
                                <span class="badge rounded-pill" style="background: linear-gradient(135deg, #6B46C1 0%, #D4AF37 100%); color: white; padding: 0.5rem 1rem; font-size: 0.9rem; box-shadow: 0 2px 4px rgba(107, 70, 193, 0.3);">
                                    <i class="bi bi-gem me-1"></i> VIP COMPLIMENTARY
                                </span>
                            @else
                                <span class="badge rounded-pill" style="background: linear-gradient(135deg, #D4AF37 0%, #C0C0C0 100%); color: white; padding: 0.5rem 1rem; font-size: 0.9rem; box-shadow: 0 2px 4px rgba(212, 175, 55, 0.3);">
                                    <i class="bi bi-gift me-1"></i> COMPLIMENTARY
                                </span>
                            @endif
                        @else
                            <span class="badge rounded-pill bg-dark text-white" style="padding: 0.5rem 1rem; font-size: 0.9rem;">
                                <i class="bi bi-ticket-perforated me-1"></i> STANDARD TICKET
                            </span>
                        @endif
                    </div>

                    @if($ticket->payment_status !== 'completed')
                        <div class="status danger mt-3">Payment not completed for this ticket.</div>
                    @endif

                    <!-- Ticket Summary -->
                    <div class="ticket-summary mt-3">
                        <div class="summary-row">
                            <span class="summary-label">Reference</span>
                            <span class="summary-value">{{ $ticket->reference }}</span>
                        </div>
                        <div class="summary-row">
                            <span class="summary-label">Qty</span>
                            <span class="summary-value">{{ $ticket->quantity }}</span>
                        </div>
                        <div class="summary-row">
                            <span class="summary-label">Attendee</span>
                            <span class="summary-value">{{ trim(($ticket->first_name ?? '').' '.($ticket->last_name ?? '')) }}</span>
                        </div>
                        <div class="summary-row">
                            <span class="summary-label">Phone</span>
                            <span class="summary-value">{{ $ticket->phone ?? 'N/A' }}</span>
                        </div>
                        <div class="summary-row">
                            <span class="summary-label">Purchased</span>
                            <span class="summary-value">
                                {{ ($ticket->payment_date ?? $ticket->created_at)->setTimezone('Africa/Nairobi')->format('M d, Y H:i') }}
                            </span>
                        </div>
                    </div>

                    @if($scanCount >= $ticket->quantity)
                        <div class="status warn mt-3">Ticket already scanned ({{ $scanCount }} of {{ $ticket->quantity }}).
                            @if($lastScan) Last scan: {{ \Carbon\Carbon::parse($lastScan->created_at)->timezone('Africa/Nairobi')->format('M d, Y H:i') }} @endif
                        </div>
                    @endif

                    @if($ticket->payment_status === 'completed')
                        <!-- Verify All (if any left) -->
                        @if($scanCount < $ticket->quantity)
                            <form method="POST" action="{{ route('ticket.verify.process') }}" class="mb-3 mt-3">
                                @csrf
                                <input type="hidden" name="reference" value="{{ $ticket->reference }}">
                                <input type="hidden" name="verify_all" value="1">
                                <button type="submit" class="btn-verify w-100">Verify All</button>
                            </form>
                        @endif

                        <!-- Per-Unit List -->
                        <div class="unit-list">
                            @for($i = 1; $i <= $ticket->quantity; $i++)
                                @php
                                    $isVerified = $i <= $scanCount;
                                    $isNext = $i == ($scanCount + 1);
                                @endphp
                                <div class="unit-item">
                                    <div class="unit-info">
                                        <span class="unit-label">Ticket {{ $i }}</span>
                                        @if($isVerified)
                                            <span class="unit-status verified">Verified</span>
                                        @else
                                            <span class="unit-status pending">Pending</span>
                                        @endif
                                    </div>
                                    @if($isNext)
                                        <form method="POST" action="{{ route('ticket.verify.process') }}" class="m-0">
                                            @csrf
                                            <input type="hidden" name="reference" value="{{ $ticket->reference }}">
                                            <input type="hidden" name="index" value="{{ $i }}">
                                            <button type="submit" class="btn-verify-unit">Verify</button>
                                        </form>
                                    @elseif(!$isVerified)
                                        <button type="button" class="btn-verify-unit" style="opacity: 0.4; cursor: not-allowed;" disabled>Verify</button>
                                    @endif
                                </div>
                            @endfor
                        </div>
                    @endif
                @endif
            </div>
        </div>
    </div>
</div>
<script>
    const phoneInput = document.getElementById('phoneInput');
    const form = document.getElementById('verifyForm');
    
    // Auto-submit on Enter key
    phoneInput.addEventListener('keypress', (e) => {
        if (e.key === 'Enter') {
            e.preventDefault();
            form.submit();
        }
    });
</script>
</body>
</html>

