<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tickets Analytics - Admin Panel</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="PACE Events" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <!-- Primary Meta Tags -->
        <meta name="title" content="PACE" />
        <meta name="description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
    
        <!-- Open Graph / Facebook -->
        <meta property="og:type" content="website" />
        <meta property="og:url" content="https://events.pacesetter.co.ke/" />
        <meta property="og:title" content="PACE" />
        <meta property="og:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="og:image" content="https://events.pacesetter.co.ke/assets/img/logo/logo.png" />
    
        <!-- Twitter -->
        <meta property="twitter:card" content="summary_large_image" />
        <meta property="twitter:url" content="https://events.pacesetter.co.ke/" />
        <meta property="twitter:title" content="PACE" />
        <meta property="twitter:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="twitter:image" content="https://events.pacesetter.co.ke/assets/img/logo/logo.png" />
    
    

       
        <link
          rel="shortcut icon"
          type="image/x-icon"
          href="assets/img/logo/logo.png"
        />
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <style>
        .analytics-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 1.5rem;
        }
        
        .stats-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .stats-card.success {
            background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        }
        
        .stats-card.warning {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        }
        
        .stats-card.info {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        }
        
        .chart-container {
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        
        .btn-primary {
            background-color: #6c04f5;
            border-color: #6c04f5;
        }
        
        .btn-primary:hover {
            background-color: #5a03d1;
            border-color: #5a03d1;
        }
        
        .table-responsive {
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        
        .table th {
            background-color: #6c04f5;
            color: white;
            border: none;
            font-weight: 600;
        }
        
        .amount-display {
            font-weight: 600;
            color: #28a745;
        }
        
        @media (max-width: 768px) {
            .chart-container {
                padding: 1rem;
            }
            
            .stats-card {
                padding: 1rem;
            }
            
            .stats-card h4 {
                font-size: 1.5rem;
            }
        }

        .analytics-nav {
        padding: 1rem;
        background: white;
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
    }

    .analytics-nav .btn {
        min-width: 150px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
    }

    .analytics-nav .btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .analytics-nav .btn.active {
        background-color: #6c04f5;
        color: white;
        border-color: #6c04f5;
    }

    .analytics-nav .btn.active:hover {
        background-color: #5a03d1;
        border-color: #5a03d1;
    }

    @media (max-width: 768px) {
        .analytics-nav .btn {
            min-width: 120px;
            font-size: 0.9rem;
        }
    }
    </style>
</head>
<body class="bg-light">
    <div class="container analytics-container">
        
        <!-- Header -->
        {{-- <div class="flex-wrap gap-3 mb-4 analytics-nav d-flex justify-content-center align-items-center">
    @can('view-tickets')
        <a href="{{ route('tickets.index') }}" class="btn btn-primary btn-lg rounded-pill">
            <i class="fas fa-list me-2"></i> All Tickets
        </a>
    @endcan
    @can('view-metrics')
        <a href="{{ route('tickets.analytics') }}" class="btn btn-outline-primary btn-lg rounded-pill active">
            <i class="fas fa-chart-bar me-2"></i> Analytics
        </a>
    @endcan
    @can('access-messages')
        <a href="{{ route('sms.index') }}" class="btn btn-outline-secondary btn-lg rounded-pill">
            <i class="fas fa-sms me-2"></i> SMS Manager
        </a>
    @endcan
    @can('access-complimentary')
        <a href="{{ route('complimentary.tickets.index') }}" class="btn btn-outline-dark btn-lg rounded-pill">
            <i class="fas fa-home me-2"></i> Manage Complimentary Tickets
        </a>
    @endcan
</div> --}}


        <!-- Daily Sales Chart -->
        <div class="chart-container">
            <h4 class="mb-3">
                <i class="fas fa-chart-line text-primary"></i>
                Daily Sales (Last 30 Days)
            </h4>
            <canvas id="dailySalesChart" height="100"></canvas>
        </div>

        <!-- Sales by School -->
        <div class="row">
            <div class="col-lg-6">
                <div class="chart-container">
                    <h4 class="mb-3">
                        <i class="fas fa-graduation-cap text-primary"></i>
                        Sales by School
                    </h4>
                    <canvas id="schoolSalesChart"></canvas>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="chart-container">
                    <h4 class="mb-3">
                        <i class="fas fa-calendar text-primary"></i>
                        Sales by Event
                    </h4>
                    <canvas id="eventSalesChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Payment Status Distribution -->
        <div class="chart-container">
            <h4 class="mb-3">
                <i class="fas fa-pie-chart text-primary"></i>
                Payment Status Distribution
            </h4>
            <div class="row">
                <div class="col-lg-6">
                    <canvas id="statusChart"></canvas>
                </div>
                <div class="col-lg-6">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Status</th>
                                    <th>Count</th>
                                    <th>Percentage</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $totalTickets = $statusDistribution->sum('count');
                                @endphp
                                @foreach($statusDistribution as $status)
                                    <tr>
                                        <td>
                                            @if($status->payment_status === 'completed')
                                                <span class="badge bg-success">Completed</span>
                                            @elseif($status->payment_status === 'pending')
                                                <span class="badge bg-warning">Pending</span>
                                            @else
                                                <span class="badge bg-danger">Failed</span>
                                            @endif
                                        </td>
                                        <td>{{ number_format($status->count) }}</td>
                                        <td>{{ number_format(($status->count / $totalTickets) * 100, 1) }}%</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Schools Table -->
        <div class="chart-container">
            <h4 class="mb-3">
                <i class="fas fa-trophy text-primary"></i>
                Top Performing Schools
            </h4>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Rank</th>
                            <th>School</th>
                            <th>Tickets Sold</th>
                            <th>Revenue</th>
                            <th>Average Ticket Value</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($schoolSales as $index => $school)
                            <tr>
                                <td>
                                    @if($index === 0)
                                        <span class="badge bg-warning">🥇 1st</span>
                                    @elseif($index === 1)
                                        <span class="badge bg-secondary">🥈 2nd</span>
                                    @elseif($index === 2)
                                        <span class="badge bg-danger">🥉 3rd</span>
                                    @else
                                        <span class="text-muted">#{{ $index + 1 }}</span>
                                    @endif
                                </td>
                                <td><strong>{{ $school->school }}</strong></td>
                                <td>{{ number_format($school->count) }}</td>
                                <td class="amount-display">KSH {{ number_format($school->revenue, 2) }}</td>
                                <td>KSH {{ number_format($school->revenue / $school->count, 2) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="py-3 text-center">
                                    <i class="mb-2 fas fa-graduation-cap fa-2x text-muted"></i>
                                    <p class="mb-0 text-muted">No school data available</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Event Performance Table -->
        <div class="chart-container">
            <h4 class="mb-3">
                <i class="fas fa-calendar-check text-primary"></i>
                Event Performance
            </h4>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Event</th>
                            <th>Tickets Sold</th>
                            <th>Revenue</th>
                            <th>Average Ticket Value</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($eventSales as $event)
                            <tr>
                                <td><strong>{{ $event->event_name }}</strong></td>
                                <td>{{ number_format($event->count) }}</td>
                                <td class="amount-display">KSH {{ number_format($event->revenue, 2) }}</td>
                                <td>KSH {{ number_format($event->revenue / $event->count, 2) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="py-3 text-center">
                                    <i class="mb-2 fas fa-calendar fa-2x text-muted"></i>
                                    <p class="mb-0 text-muted">No event data available</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Daily Sales Chart
            const dailySalesCtx = document.getElementById('dailySalesChart').getContext('2d');
            new Chart(dailySalesCtx, {
                type: 'line',
                data: {
                    labels: @json($dailySales->pluck('date')),
                    datasets: [{
                        label: 'Tickets Sold',
                        data: @json($dailySales->pluck('count')),
                        borderColor: '#6c04f5',
                        backgroundColor: 'rgba(108, 4, 245, 0.1)',
                        tension: 0.4,
                        fill: true
                    }, {
                        label: 'Revenue (KSH)',
                        data: @json($dailySales->pluck('revenue')),
                        borderColor: '#28a745',
                        backgroundColor: 'rgba(40, 167, 69, 0.1)',
                        tension: 0.4,
                        fill: true,
                        yAxisID: 'y1'
                    }]
                },
                options: {
                    responsive: true,
                    interaction: {
                        mode: 'index',
                        intersect: false,
                    },
                    scales: {
                        x: {
                            display: true,
                            title: {
                                display: true,
                                text: 'Date'
                            }
                        },
                        y: {
                            type: 'linear',
                            display: true,
                            position: 'left',
                            title: {
                                display: true,
                                text: 'Tickets Sold'
                            }
                        },
                        y1: {
                            type: 'linear',
                            display: true,
                            position: 'right',
                            title: {
                                display: true,
                                text: 'Revenue (KSH)'
                            },
                            grid: {
                                drawOnChartArea: false,
                            },
                        }
                    }
                }
            });

            // School Sales Chart
            const schoolSalesCtx = document.getElementById('schoolSalesChart').getContext('2d');
            new Chart(schoolSalesCtx, {
                type: 'bar',
                data: {
                    labels: @json($schoolSales->pluck('school')),
                    datasets: [{
                        label: 'Revenue (KSH)',
                        data: @json($schoolSales->pluck('revenue')),
                        backgroundColor: 'rgba(108, 4, 245, 0.8)',
                        borderColor: '#6c04f5',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Revenue (KSH)'
                            }
                        }
                    }
                }
            });

            // Event Sales Chart
            const eventSalesCtx = document.getElementById('eventSalesChart').getContext('2d');
            new Chart(eventSalesCtx, {
                type: 'doughnut',
                data: {
                    labels: @json($eventSales->pluck('event_name')),
                    datasets: [{
                        data: @json($eventSales->pluck('revenue')),
                        backgroundColor: [
                            '#6c04f5',
                            '#28a745',
                            '#ffc107',
                            '#dc3545',
                            '#17a2b8',
                            '#6f42c1',
                            '#fd7e14',
                            '#20c997'
                        ],
                        borderWidth: 2
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        }
                    }
                }
            });

            // Status Distribution Chart
            const statusCtx = document.getElementById('statusChart').getContext('2d');
            new Chart(statusCtx, {
                type: 'pie',
                data: {
                    labels: @json($statusDistribution->pluck('payment_status')),
                    datasets: [{
                        data: @json($statusDistribution->pluck('count')),
                        backgroundColor: [
                            '#28a745', // completed
                            '#ffc107', // pending
                            '#dc3545'  // failed
                        ],
                        borderWidth: 2
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        }
                    }
                }
            });
        });
    </script>
</body>
</html>