#!/bin/bash

# Setup script for STK Status Checker Cron Job
echo "Setting up STK Status Checker Cron Job..."

# Get the current directory
CURRENT_DIR=$(pwd)

# Create the cron job entry
CRON_JOB="*/5 * * * * cd $CURRENT_DIR && php artisan schedule:run >> /dev/null 2>&1"

# Check if the cron job already exists
if crontab -l 2>/dev/null | grep -q "php artisan schedule:run"; then
    echo "Cron job already exists. Skipping..."
else
    # Add the cron job
    (crontab -l 2>/dev/null; echo "$CRON_JOB") | crontab -
    echo "Cron job added successfully!"
fi

echo ""
echo "Cron job details:"
echo "Command: $CRON_JOB"
echo "Frequency: Every 5 minutes"
echo "Purpose: Check STK status for launched transactions"
echo ""
echo "To manually test the command:"
echo "php artisan stk:check-status --limit=10"
echo ""
echo "To view scheduled tasks:"
echo "php artisan schedule:list"
echo ""
echo "To run the scheduler manually:"
echo "php artisan schedule:run" 