<!DOCTYPE html>
<html class="no-js" lang="en">
  <head>
    <meta charset="utf-8" />
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <title>PACE</title>
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <!-- Primary Meta Tags -->
        <meta name="title" content="PACE" />
        <meta name="description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
    
        <!-- Open Graph / Facebook -->
        <meta property="og:type" content="website" />
        <meta property="og:url" content="https://events.pacesetter.co.ke/" />
        <meta property="og:title" content="PACE" />
        <meta property="og:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="og:image" content="https://events.pacesetter.co.ke/assets/img/logo/logo.png" />
    
        <!-- Twitter -->
        <meta property="twitter:card" content="summary_large_image" />
        <meta property="twitter:url" content="https://events.pacesetter.co.ke/" />
        <meta property="twitter:title" content="PACE" />
        <meta property="twitter:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="twitter:image" content="https://events.pacesetter.co.ke/assets/img/logo/logo.png" />



    <link
      rel="shortcut icon"
      type="image/x-icon"
      href="<?php echo e(asset('assets/img/logo/logo.png')); ?>"
    />
    <!-- Place favicon.ico in the root directory -->

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- CSS here -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/fontawesome-all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/flaticon_mycollection.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/swiper-bundle.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/odometer.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/default.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/main.css')); ?>" />

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        .contact-form-container {
          background: linear-gradient(to right, rgb(252, 249, 249), rgb(243, 241, 241), white);
          box-shadow: -5px 5px 15px rgba(1, 6, 36, 0.5);
          border-radius: 8px;
          padding: 30px;
        }
      
        .form-input {
          box-shadow: 0 4px 10px rgba(248, 247, 247, 0.979);
          border: none;
          border-radius: 5px;
          padding: 12px;
        }
      
        .form-btn {
          background-color: #6c04f5;
          color: white;
          border: none;
          border-radius: 5px;
          padding: 12px;
          box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
          justify-content: center;
          align-self: center;
        }
      
        .form-btn:hover {
          background-color: #db2777;
          color: white;
        }
            .td-breadcrumb-area {
              position: relative;
              background: url("<?php echo e(asset('assets/img/logo/logo.png')); ?>") center center / cover no-repeat;
            }
            .td-breadcrumb-area::before {
              content: "";
              position: absolute;
              inset: 0;
              background: rgba(0, 0, 0, 0.5); /* Adjust opacity as needed */
            }
            .td-breadcrumb-area .container {
              position: relative;
              z-index: 1;
            }
          
      </style>
  </head>

  <body>
    <!-- Preloader Start -->
    <div class="preloader">
      <div class="loader"></div>
    </div>
    <!-- Preloader End -->

    <!-- Scroll-top -->
    <button class="scroll__top scroll-to-target" data-target="html">
      <i class="fa-sharp fa-regular fa-arrow-up"></i>
    </button>
    <!-- Scroll-top-end-->

    <!-- header-search -->
    <div class="search__popup">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="search__wrapper">
              <div class="search__close">
                <button type="button" class="search-close-btn">
                  <svg
                    width="18"
                    height="18"
                    viewBox="0 0 18 18"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      d="M17 1L1 17"
                      stroke="currentColor"
                      stroke-width="1.5"
                      stroke-linecap="round"
                      stroke-linejoin="round"
                    ></path>
                    <path
                      d="M1 1L17 17"
                      stroke="currentColor"
                      stroke-width="1.5"
                      stroke-linecap="round"
                      stroke-linejoin="round"
                    ></path>
                  </svg>
                </button>
              </div>
              <div class="search__form">
                
                  <div class="search__input">
                    <input
                      class="search-input-field"
                      type="text"
                      placeholder="Type keywords here"
                    />
                    <span class="search-focus-border"></span>
                    <button type="submit">
                      <svg
                        width="20"
                        height="20"
                        viewBox="0 0 20 20"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M9.55 18.1C14.272 18.1 18.1 14.272 18.1 9.55C18.1 4.82797 14.272 1 9.55 1C4.82797 1 1 4.82797 1 9.55C1 14.272 4.82797 18.1 9.55 18.1Z"
                          stroke="currentColor"
                          stroke-width="1.5"
                          stroke-linecap="round"
                          stroke-linejoin="round"
                        ></path>
                        <path
                          d="M19.0002 19.0002L17.2002 17.2002"
                          stroke="currentColor"
                          stroke-width="1.5"
                          stroke-linecap="round"
                          stroke-linejoin="round"
                        ></path>
                      </svg>
                    </button>
                  </div>
                
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="search-popup-overlay"></div>
    <!-- header-search-end -->

    <!-- cart mini area start -->

    <div class="body-overlay"></div>
    <!-- cart mini area end -->

    <!-- header-area -->
    <header class="td-header-height">
      <div class="td-header__area z-index-999 td-transparent">
        <div class="td-header-3-top d-none d-lg-block">
          <div class="container-fluid container-1680">
            <div class="row">
              <div class="col-lg-6">
                <div class="td-header-3-top-info">
                  <span
                    ><a href="#"
                      ><i class="flaticon-gps"></i>Nairobi, Kenya</a
                    ></span
                  >
                  <span class="dvdr">/</span>
                  <span
                    ><a href="tel:+254726846918"
                      ><i class="flaticon-phone"></i>+254 726-846 918</a
                    ></span
                  >
                </div>
              </div>
              <div class="col-lg-6">
                <div class="d-none d-lg-block">
                  <div
                    class="td-header-3-top-social d-flex align-items-center justify-content-end"
                  >
                    <span class="td-email"
                      ><a href="mailto:thepacesettertalentshow@gmail.com"
                        ><i class="flaticon-mail"></i>Thepacesettertalentshow@gmail.com</a
                      ></span
                    >
                    <span class="dvdr">/</span>
                    <span
                      ><a href="https://www.facebook.com/p/The-Pace-setter-Mag-61550425191042/"><i class="fa-brands fa-facebook"></i></a
                    ></span>
                    <span>
                      <a href="#">
                        <svg
                          width="19"
                          height="19"
                          viewBox="0 0 19 19"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path
                            d="M13.8679 1.60596H16.4382L10.8229 8.02398L17.4289 16.7575H12.2564L8.20515 11.4607L3.56956 16.7575H0.997689L7.00391 9.89267L0.666687 1.60596H5.97049L9.6325 6.44745L13.8679 1.60596ZM12.9658 15.219H14.3901L5.1966 3.06361H3.66824L12.9658 15.219Z"
                            fill="currentColor"
                          />
                        </svg>
                      </a>
                    </span>
                    <span
                      ><a href="https://www.facebook.com/p/The-Pace-setter-Mag-61550425191042/"><i class="fa-brands fa-instagram"></i></a
                    ></span>
                    <span
                      ><a href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event"><i class="fa-brands fa-whatsapp"></i></a
                    ></span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div id="header-sticky" class="header-mobile-spacing">
          <div class="container-fluid container-1680">
            <div class="row align-items-center">
              <div class="col-xxl-9 col-xl-9 col-6">
                <div
                  class="tdmenu__wrap d-flex align-items-center justify-content-between"
                >
                  <div class="logo">
                    <a class="logo-1 logo-sticky-none" href="/"
                      ><img
                        data-width="150"
                        src="<?php echo e(asset('assets/img/logo/logo.png')); ?>"
                        alt="Logo"
                    /></a>
                    <a class="logo-2 d-none" href="/"
                      ><img
                        data-width="150"
                        src="<?php echo e(asset('assets/img/logo/logo.png')); ?>"
                        alt="Logo"
                    /></a>
                  </div>
                  <nav
                    class="mr-40 tdmenu__nav tdmenu-3 ml-50 d-none d-xl-flex"
                  >
                    <div class="tdmenu__navbar-wrap tdmenu__main-menu">
                      <ul class="navigation">
                        <li class="menu-item-has-children">
                          <a href="/">Home</a>
                        </li>
                        <li class="menu-item-has-children">
                          <a href="#">Events</a>
                        </li>
                        <li class="menu-item-has-children">
                          <a href="#">Speakers</a>
                        </li>

                        <li class="menu-item-has-children">
                          <a href="<?php echo e(route('contact')); ?>">Contact</a>
                        </li>
                        <li class="active">
                          <a href="<?php echo e(route('ticket', ['slug' => $highlightedEvent->slug])); ?>" 
                            class="buy-ticket-link"
                            data-event-id="<?php echo e($highlightedEvent->id); ?>"
                            data-amount="<?php echo e($highlightedEvent->tickets['advance']); ?>">
                            Buy Ticket                            
                         </a>
                        </li>
                      </ul>
                    </div>
                  </nav>
                </div>
              </div>
              <div class="col-xxl-3 col-xl-3 col-6">
                <div
                  class="td-menu-right-action td-menu-right-action-3 d-flex align-items-center justify-content-end"
                >
                  <div class="ml-20 td-header-menu-bar lh-1 p-relative">
                    <button
                      class="tdmenu-offcanvas-open-btn mobile-nav-toggler d-block d-xl-none"
                    >
                      <span></span>
                      <span></span>
                      <span></span>
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Mobile Menu  -->
      <div class="tdmobile__menu">
        <nav class="tdmobile__menu-box">
          <div class="close-btn"><i class="fa-solid fa-xmark"></i></div>
          <div class="nav-logo">
            <a href="/"
              ><img src="<?php echo e(asset('assets/img/logo/logo.png')); ?>" alt="logo"
            /></a>
          </div>
          
          <div class="tdmobile__menu-outer">
            <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
          </div>
          <div class="social-links">
            <ul class="list-wrap">
              <li>
                <a href="https://www.facebook.com/p/The-Pace-setter-Mag-61550425191042/"><i class="fab fa-facebook-f"></i></a>
              </li>
              <li>
                <a href="https://x.com/the_pace_mag"><i class="fab fa-twitter"></i></a>
              </li>
              <li>
                <a href="https://www.instagram.com/pace_setter_mag/"><i class="fab fa-instagram"></i></a>
              </li>
              <li>
                <a href="http://www.youtube.com/@ThePaceSetterMag"><i class="fab fa-youtube"></i></a>
              </li>
            </ul>
          </div>
        </nav>
      </div>
      <div class="tdmobile__menu-backdrop"></div>
      <!-- End Mobile Menu -->

      <!-- offCanvas-menu -->
      <div class="offCanvas__info">
        <div class="offCanvas__close-icon menu-close">
          <button><i class="fa-sharp fa-regular fa-xmark"></i></button>
        </div>
        <div class="offCanvas__logo mb-30">
          <a href="/"
            ><img src="<?php echo e(asset('assets/img/logo/logo.png')); ?>" alt="Logo"
          /></a>
        </div>
        <div class="offCanvas__side-info mb-30">
          <div class="contact-list mb-30">
            <h4>Office Address</h4>
            <a href="https://www.google.com/maps" target="_blank"
              >Nairobi <br />
              Kenya</a
            >
          </div>
          <div class="contact-list mb-30">
            <h4>Phone Number</h4>
            <a href="tel:(090)87658654385">+0989 7876 9865 9</a>
            <a href="tel:(090)87658654385">+(090) 8765 86543 85</a>
          </div>
          <div class="contact-list mb-30">
            <h4>Email Address</h4>
            <a href="mailto:thepacesettertalentshow@gmail.com">Thepacesettertalentshow@gmail.com</a>
          </div>
        </div>
        <div class="offCanvas__social-icon mt-30">
          <a href="javascript:void(0)"><i class="fab fa-facebook-f"></i></a>
          <a href="javascript:void(0)"><i class="fab fa-twitter"></i></a>
          <a href="javascript:void(0)"><i class="fab fa-google-plus-g"></i></a>
          <a href="javascript:void(0)"><i class="fab fa-instagram"></i></a>
        </div>
      </div>
      <div class="offCanvas__overly"></div>
      <!-- offCanvas-menu-end -->
    </header>
    <!-- header-area-end -->

    <!-- main-area -->
    <main>
      <!-- td-breadcrumb-area-start -->
      
      
      <div class="td-breadcrumb-area td-breadcrumb-spacing bg-position">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <div class="td-breadcrumb-title-wrap">
                <h2
                  class="mb-10 td-breadcrumb-title wow td-animetion-left"
                  data-wow-duration="1.5s"
                  data-wow-delay="0.3s"
                >
                  TeenzFest 2025
                </h2>
                <div
                  class="td-breadcrumb-list wow td-animetion-right"
                  data-wow-duration="1.5s"
                  data-wow-delay="0.3s"
                >
                  <ul>
                    <li><a href="/">Home</a></li>
                    <li>
                      <i class="fa-sharp fa-solid fa-angle-right fa-fw"></i>
                    </li>
                    <li class="pages">TeenzFest 2025</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- td-breadcrumb-area-end -->


      
      
 <!-- td-contact-form-area-start -->
<div class="container mt-3 d-flex justify-content-center">
  <div class="contact-form-container col-lg-8 col-xl-6 col-sm-12">
    <!-- Lipa Na M-Pesa Image -->
    <div class="mb-3 text-center">
      <img src="<?php echo e(asset('assets\img\Lipa na mpesa.png')); ?>" alt="Lipa Na M-Pesa" style="max-height: 100px; width:200px;" class="img-fluid">
    </div>
    
    <h3 class="mb-4 text-center text-secondary">TeenzFest 2025</h3>
    <div id="response-message" class="mt-3 text-center alert" style="display: none;"></div>
    <form id="contact-form" action="<?php echo e(route('buy-ticket')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <div class="mb-3 row">
        <div class="col">
          <input type="text" class="form-control form-input" name="firstName" placeholder="First Name" required 
                 pattern="^[A-Za-z\s\-']+$" 
                 title="Please enter a valid first name (letters, spaces, hyphens, and apostrophes only).">
          <div class="invalid-feedback">Please enter a valid first name</div>
        </div>
        <div class="col">
          <input type="text" class="form-control form-input" name="lastName" placeholder="Last Name" required 
                 pattern="^[A-Za-z\s\-']+$" 
                 title="Please enter a valid last name (letters, spaces, hyphens, and apostrophes only).">
          <div class="invalid-feedback">Please enter a valid last name</div>
        </div>
      </div>
      <div class="mb-3">
        <input type="tel" class="form-control form-input" name="phone" placeholder="Phone Number (e.g., 0712345678)" required 
               pattern="^(?:\+254|0)?[17]\d{8}$" 
               title="Please enter a valid Kenyan phone number starting with 07, 01, +2547 or +2541 no spaces">
        <div class="invalid-feedback">Please enter a valid Kenyan phone number</div>
      </div>
      <div class="mb-3">
        <input type="email" class="form-control form-input" name="email" placeholder="Email" required 
               pattern="^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$" 
               title="Please enter a valid email address">
        <div class="invalid-feedback">Please enter a valid email address</div>
      </div>
      
      <div class="mb-3">
        <input type="text" class="form-control form-input" name="school" placeholder="School" required 
               pattern="^[A-Za-z\s\-.,&']+$" 
               title="Please enter a valid school name">
        <div class="invalid-feedback">Please enter your school name</div>
      </div>
      <!-- Ticket Type Selection -->
        <div class="mb-3 position-relative">
            <select class="form-control form-input" name="ticket_type" required title="Please select ticket type.">
                <option value="" disabled selected>Select Ticket Type</option>
                <option value="advance">Advance - KES 800 per ticket</option>
                <option value="group_4">Group of 4 - KES 2,500 per group</option>
                <option value="group_5">Group of 5 - KES 3,500 per group</option>
                <option value="group_10">Group of 10 - KES 6,500 per group</option>
                <option value="gate">Gate Price - KES 1,000 per ticket</option>
            </select>
            <span class="position-absolute" style="top: 50%; right: 45px; transform: translateY(-50%); pointer-events: none; font-size: 2.4rem;">
                &#9662;
            </span>
            <div class="invalid-feedback">Please select ticket type</div>
        </div>

              <!-- Quantity Selection (now means number of packages/groups) -->
        <div class="mb-3 position-relative">
            <select class="form-control form-input" name="ticket_quantity" required title="Please select quantity.">
                <option value="" disabled selected>Select Quantity</option>
                <?php for($i = 1; $i <= 10; $i++): ?>
                    <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                <?php endfor; ?>
            </select>
            <span class="position-absolute" style="top: 50%; right: 45px; transform: translateY(-50%); pointer-events: none; font-size: 2.4rem;">
                &#9662;
            </span>
            <div class="invalid-feedback">Please select quantity</div>
        </div>
      
      <!-- Hidden Input -->
      <input type="hidden" name="event_id" value="<?php echo e($event->id); ?>">
      <p class="mt-3 mb-3 text-center small text-muted">
        By continuing, you accept our 
        <a href="#" data-bs-toggle="modal" data-bs-target="#termsModal" class="text-decoration-none text-primary">
          Ticket Terms & Conditions
        </a>.
      </p>

      <button type="submit" class="justify-between form-btn btn-sm col-sm-12 col-lg-12 col-xl-12">
        <span class="submit-text">Buy Ticket</span>
        <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
      </button>
    </form>
  </div>
</div>
<!-- td-contact-form-area-end -->
<!-- Modal -->
          <div class="mb-4 modal fade" id="termsModal" tabindex="-1" aria-labelledby="termsModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered">
              <div class="modal-content">

                <div class="modal-header">
                  <h5 class="modal-title" id="termsModalLabel">Terms & Conditions</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="p-0 modal-body" style="height: 80vh;">
                  <iframe 
                    src="<?php echo e(asset('assets/Terms and conditions.pdf')); ?>" 
                    width="100%" 
                    height="100%" 
                    style="border:none;"
                  ></iframe>
                </div>

                <div class="modal-footer">
                  <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Close</button>
                </div>

              </div>
            </div>
          </div>



    
    </main>
    <!-- main-area-end -->

    <!-- footer-area-start -->
    <footer>
        <div
          class="td-footer-area td-footer-2-spacing bg-position bg-dark"
          data-background="assets/img/footer/bg.jpg"
        >
          <div class="container">
            <div class="row mb-15">
              <div class="col-xl-3 col-lg-3 col-md-5">
                <div class="mb-40 td-footer-widget">
                  <div class="mb-20 td-footer-logo">
                    <a href="/"
                      ><img src="<?php echo e(asset('assets/img/logo/logo.png')); ?>" alt="logo"
                    /></a>
                  </div>
                  <p class="mb-10 text">
                    Nairobi,Kenya
                  </p>
                  <a
                    class="mb-10 number d-inline-block"
                    href="tel:+254726846918"
                    >+(254) 726-846 918</a
                  >
                  <a class="email" href="mailto:Thepacesettertalentshow@gmail.com">Thepacesettertalentshow@gmail.com</a>
                </div>
              </div>
              <div class="col-xl-5 col-lg-4 col-md-7">
                <div class="mb-40 td-footer-widget space ml-90">
                  <h3 class="mb-20 td-footer-title">Quick links</h3>
                  <div class="row">
                    <div class="col-lg-6 col-md-6 col-sm-6">
                      <div class="td-footer-links">
                        <ul>
                          <li><a href="#">About this Event</a></li>
                          <li><a href="#">Venue</a></li>
                          <li><a href="#">Speakers</a></li>
                          <li><a href="#">Agenda</a></li>
                          <li><a href="#">Sponsors</a></li>
                        </ul>
                      </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-6">
                      <div class="td-footer-links">
                        <ul>
                          <li><a href="#">News</a></li>
                          <li>
                            <a href="<?php echo e(route('ticket', ['slug' => $highlightedEvent->slug])); ?>" 
                              class="buy-ticket-link"
                              data-event-id="<?php echo e($highlightedEvent->id); ?>">
                              Buy Ticket
                           </a>
                          </li>
                          
                          <li><a href="#">Benefits</a></li>
                          <li><a href="#">Contact Us</a></li>
                        </ul>
                      </div>
                    </div>
                  </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-5 col-md-6">
              <div class="mb-40 td-footer-2-widget space ml-90">
                <h3 class="td-footer-title mb-25"></h3>
                <div class="row gx-10">
                  <a aria-label="Chat on WhatsApp" 
                     href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event" 
                     target="_blank">
                    <img alt="Chat on WhatsApp" src="<?php echo e(asset('assets/img/whatsapp/WhatsAppButtonGreenLarge.png')); ?>" />
                  </a>
                </div>
              </div>
              
            </div>
            <div class="row">
              <div class="col-12">
                <div class="pt-40 td-footer-bottom pb-15">
                  <div class="row align-items-center">
                    
                    <!-- Left: Copyright -->
                    <div class="col-md-6">
                      <div class="td-footer-bottom-copyright mb-30">
                        <p>
                          Copyright © <span id="current-year"></span> pacesetter.co.ke All rights reserved.
                        </p>
                      </div>
                    </div>

                    <!-- Middle: Terms & Conditions -->
                    <div class="col-md-3 text-md-center">
                      <div class="td-footer-bottom-terms mb-30">
                        <!-- Button -->
                        <a href="#" class="text-decoration-none" data-bs-toggle="modal" data-bs-target="#termsModal">
                          Terms & Conditions
                        </a>

                      </div>
                    </div>

                    <!-- Right: Social Links -->
                    <div class="col-md-3 text-md-right">
                      <div class="td-footer-bottom-social mb-30">
                        <span>
                          <a href="https://www.instagram.com/pace_setter_mag/">
                            <i class="fa-brands fa-instagram"></i>
                          </a>
                        </span>
                        <span>
                          <a href="https://x.com/the_pace_mag">
                            <svg
                              width="21"
                              height="18"
                              viewBox="0 0 21 18"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                d="M16.3783 0.111328H19.3942L12.8054 7.64181L20.5565 17.8891H14.4875L9.73399 11.6742L4.2949 17.8891H1.27723L8.32453 9.83441L0.888855 0.111328H7.11199L11.4087 5.79201L16.3783 0.111328ZM15.3199 16.084H16.991L6.20396 1.82164H4.41068L15.3199 16.084Z"
                                fill="currentColor"
                              />
                            </svg>
                          </a>
                        </span>
                        <span
                            ><a href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event"><i class="fa-brands fa-whatsapp"></i></a
                          ></span>
                      </div>
                    </div>

                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </footer>
      <!-- footer-area-end -->
      <!-- Modal -->
          <div class="modal fade" id="termsModal" tabindex="-1" aria-labelledby="termsModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered">
              <div class="modal-content">

                <div class="modal-header">
                  <h5 class="modal-title" id="termsModalLabel">Terms & Conditions</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="p-0 modal-body" style="height: 80vh;">
                  <iframe 
                    src="assets/Terms and conditions.pdf" 
                    width="100%" 
                    height="100%" 
                    style="border:none;"
                  ></iframe>
                </div>

                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>

              </div>
            </div>
          </div>
  

    <!-- JS here -->
    <script src="<?php echo e(asset('assets/js/vendor/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/isotope.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/ion.rangeSlider.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/imagesloaded.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.odometer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery-appear.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/Jarallax.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/nice-select.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
      // Get the current year
      const year = new Date().getFullYear();
      // Insert the year into the span with id "current-year"
      document.getElementById("current-year").textContent = year;
    </script>
    
<script>
$(document).ready(function() {
  const form = $('#contact-form');
  const responseMessage = $('#response-message');
  const formContainer = $('.contact-form-container');
  const formTitle = $('.contact-form-container h3');
  const submitBtn = form.find('button[type="submit"]');
  const submitText = submitBtn.find('.submit-text');
  const spinner = submitBtn.find('.spinner-border');

  // Ticket pricing map
  const ticketPrices = {
    'advance': 800,
    'group_4': 1500,
    'group_5': 2000,
    'group_10': 4000,
    'gate': 1000
  };


  // Check for URL parameters to show status messages
  const urlParams = new URLSearchParams(window.location.search);
  const status = urlParams.get('status');
  const message = urlParams.get('message');

  if (status && message) {
    responseMessage.show().removeClass().addClass(`alert alert-${status} mt-3 text-center`).text(decodeURIComponent(message));
    
    setTimeout(() => {
      responseMessage.hide();
      window.history.replaceState({}, document.title, window.location.pathname);
    }, 5000);
  }

  // Real-time validation feedback
  form.find('.form-input').on('input', function() {
    if (this.checkValidity()) {
      $(this).removeClass('is-invalid').addClass('is-valid');
    } else {
      $(this).removeClass('is-valid');
    }
  }).on('blur', function() {
    if (!this.checkValidity()) {
      $(this).addClass('is-invalid');
    }
  });

  form.on('submit', async function(e) {
    e.preventDefault();
    
    // Validate all fields
    let isValid = true;
    form.find('.form-input').each(function() {
      if (!this.checkValidity()) {
        $(this).addClass('is-invalid');
        isValid = false;
      }
    });

    if (!isValid) {
      return;
    }

    // Calculate total amount
    const ticketType = form.find('[name="ticket_type"]').val();
    const quantity = parseInt(form.find('[name="ticket_quantity"]').val());
    const amount = ticketPrices[ticketType] * quantity;

// Show confirmation dialog with ticket details
const result = await Swal.fire({
  title: 'Confirm Payment',
  html: `
    <div class="text-center">
      <p>Please confirm your ticket purchase:</p>
      <div class="p-3 my-3 rounded">
        <div class="mb-2 row text-start">
          <div class="col-6"><strong>Ticket Type:</strong></div>
          <div class="col-6">${getTicketTypeName(ticketType)}</div>
        </div>
        <div class="mb-2 row text-start">
          <div class="col-6"><strong>Price:</strong></div>
          <div class="col-6">KES ${ticketPrices[ticketType].toLocaleString()}</div>
        </div>
        <div class="mb-2 row text-start">
          <div class="col-6"><strong>No. of tckts:</strong></div>
          <div class="col-6">${quantity}</div>
        </div>
        <hr class="my-2">
        <div class="mb-2 row text-start">
          <div class="col-6"><strong>Subtotal:</strong></div>
          <div class="col-6">KES ${ticketPrices[ticketType].toLocaleString()} × ${quantity}</div>
        </div>
        <hr class="my-2">
        <div class="row text-start">
          <div class="col-6"><strong>Total Amount:</strong></div>
          <div class="col-6"><strong class="text-primary">KES ${amount.toLocaleString()}</strong></div>
        </div>
      </div>
    </div>
  `,
  icon: 'info',
  showCancelButton: true,
  confirmButtonColor: '#06c937',
  cancelButtonColor: '#d33',
  confirmButtonText: 'Buy Ticket',
  cancelButtonText: 'Cancel',
  reverseButtons: true
});

// Helper function to get display name for ticket type
function getTicketTypeName(ticketType) {
  const typeNames = {
    'advance': 'Early Bird Ticket',
    'group_4': 'Group of 4 Tickets',
    'group_5': 'Group of 5 Tickets', 
    'group_10': 'Group of 10 Tickets',
    'gate': 'Gate Price Ticket'
  };
  return typeNames[ticketType] || ticketType;
}

function getTicketTypeName(ticketType) {
  const typeNames = {
    'advance': 'Advance',
    'group_4': 'Group of 4',
    'group_5': 'Group of 5',
    'group_10': 'Group of 10', 
    'gate': 'Gate Price'
  };
  return typeNames[ticketType] || ticketType;
}

    // If user cancels, stop the process
    if (!result.isConfirmed) {
      return;
    }

    // Proceed with payment processing
    await processPayment();
  });

  async function processPayment() {
    // Disable submit button and show spinner
    submitBtn.prop('disabled', true);
    submitText.text('Processing...');
    spinner.removeClass('d-none');

    // Hide form and show processing message
    form.hide();
    formTitle.hide();
    responseMessage.show().removeClass().addClass('alert alert-info mt-3 text-center').text('Processing your payment request. Please wait...');

    try {
      const formData = new FormData(form[0]);
      const response = await fetch(form.attr('action'), {
        method: 'POST',
        body: formData,
        headers: {
          'X-Requested-With': 'XMLHttpRequest',
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });

      const data = await response.json();

      if (!response.ok) {
        throw new Error(data.message || 'Network response was not ok');
      }

      if (data.status === 'success') {
        responseMessage.removeClass().addClass('alert alert-success mt-3 text-center').html(`
          ${data.message || 'Payment request sent successfully!'}
          <div class="mt-2">Check your phone to complete the M-Pesa payment...</div>
        `);
        
        setTimeout(() => {
          window.location.reload();
        }, 5000);
      } else {
        throw new Error(data.message || 'An error occurred. Please try again.');
      }
    } catch (error) {
      // Show error message
      responseMessage.show().removeClass().addClass('alert alert-danger mt-3 text-center').text(error.message);
      
      // Reset form state
      form.show();
      formTitle.show();
      submitBtn.prop('disabled', false);
      submitText.text('Buy Ticket');
      spinner.addClass('d-none');
    }
  }
});
</script>
     
    </body>
</html>
<?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\ticket\index.blade.php ENDPATH**/ ?>