<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    

   <div class="container-fluid tickets-container">
        <!-- Messages -->
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle"></i>
                <?php echo session('success'); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle"></i>
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <!-- Ticket Stats -->
        <div class="row stats-row">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-metrics')): ?>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card success">
                    <div class="text-center">
                        <h4><i class="fas fa-ticket-alt"></i> <?php echo e(number_format($ticketStats['total_tickets'])); ?></h4>
                        <p class="mb-0">Total Tickets</p>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card info">
                    <div class="text-center">
                        <h4><i class="fas fa-check-circle"></i> <?php echo e(number_format($ticketStats['total_paid'])); ?></h4>
                        <p class="mb-0">Paid Tickets</p>
                    </div>
                </div>
            </div>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card warning">
                    <div class="text-center">
                        <h4><i class="fas fa-clock"></i> <?php echo e(number_format($ticketStats['total_pending'])); ?></h4>
                        <p class="mb-0">Pending</p>
                    </div>
                </div>
            </div>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card danger">
                    <div class="text-center">
                        <h4><i class="fas fa-times-circle"></i> <?php echo e(number_format($ticketStats['total_failed'])); ?></h4>
                        <p class="mb-0">Failed</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Revenue Stats - Only show for users with view-metrics permission -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-metrics')): ?>
        <div class="row stats-row">
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card">
                    <div class="text-center">
                        <h4><i class="fas fa-money-bill-wave"></i> KSH <?php echo e(number_format($ticketStats['total_revenue'], 2)); ?></h4>
                        <p class="mb-0">Total Revenue</p> 
                    </div>
                </div>
            </div>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card success">
                    <div class="text-center">
                        <h4><i class="fas fa-calendar-day"></i> <?php echo e(number_format($ticketStats['today_sales'])); ?></h4>
                        <p class="mb-0">Today's Sales</p>
                    </div>
                </div>
            </div>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card info">
                    <div class="text-center">
                        <h4><i class="fas fa-money-bill"></i> KSH <?php echo e(number_format($ticketStats['today_revenue'], 2)); ?></h4>
                        <p class="mb-0">Today's Revenue</p>
                    </div>
                </div>
            </div>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card warning">
                    <div class="text-center">
                        <h4><i class="fas fa-calendar-alt"></i> <?php echo e(number_format($ticketStats['this_month_sales'])); ?></h4>
                        <p class="mb-0">This Month</p>
                    </div>
                </div>
            </div>
        </div>
        <?php else: ?>
        <?php endif; ?>

        <!-- Search and Filters -->
        <div class="search-filters">
            <form method="GET" action="<?php echo e(route('tickets.index')); ?>" id="filter-form">
                <div class="row align-items-end">
                    <div class="col-md-3">
                        <label for="search" class="form-label">Search Tickets</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="<?php echo e($search); ?>" placeholder="Name, phone, email, school, or reference">
                    </div>
                    <div class="col-md-2">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="">All Status</option>
                            <option value="completed" <?php echo e($status === 'completed' ? 'selected' : ''); ?>>Completed</option>
                            <option value="pending" <?php echo e($status === 'pending' ? 'selected' : ''); ?>>Pending</option>
                            <option value="failed" <?php echo e($status === 'failed' ? 'selected' : ''); ?>>Failed</option>
                        </select>
                    </div>
                    
                    <div class="col-md-2">
                        <label for="school" class="form-label">School</label>
                        <select class="form-select" id="school" name="school">
                            <option value="">All Schools</option>
                            <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schoolName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($schoolName); ?>" <?php echo e($school === $schoolName ? 'selected' : ''); ?>>
                                    <?php echo e($schoolName); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="stk_status" class="form-label">STK Status</label>
                        <select class="form-select" id="stk_status" name="stk_status">
                            <option value="">All STK Status</option>
                            <option value="Success" <?php echo e($stkStatus === 'Success' ? 'selected' : ''); ?>>Success</option>
                            <option value="Launched" <?php echo e($stkStatus === 'Launched' ? 'selected' : ''); ?>>Launched</option>
                            <option value="Failed" <?php echo e($stkStatus === 'Failed' ? 'selected' : ''); ?>>Failed</option>
                            <option value="Canceled" <?php echo e($stkStatus === 'Canceled' ? 'selected' : ''); ?>>Canceled</option>
                            <option value="Timeout" <?php echo e($stkStatus === 'Timeout' ? 'selected' : ''); ?>>Timeout</option>
                            <option value="Invalid-user-input" <?php echo e($stkStatus === 'Invalid-user-input' ? 'selected' : ''); ?>>Invalid User Input</option>
                            <option value="insufficient-funds" <?php echo e($stkStatus === 'insufficient-funds' ? 'selected' : ''); ?>>Insufficient Funds</option>
                            <option value="User-cannot-be-reached" <?php echo e($stkStatus === 'User-cannot-be-reached' ? 'selected' : ''); ?>>User Cannot be Reached</option>
                            <option value="No-response-from-user" <?php echo e($stkStatus === 'No-response-from-user' ? 'selected' : ''); ?>>No Response from User</option>
                        </select>
                    </div>
                    <div class="col-md-1">
                        <label for="per_page" class="form-label">Per Page</label>
                        <select class="form-select" id="per_page" name="per_page">
                            <option value="25" <?php echo e($perPage == 25 ? 'selected' : ''); ?>>25</option>
                            <option value="50" <?php echo e($perPage == 50 ? 'selected' : ''); ?>>50</option>
                            <option value="100" <?php echo e($perPage == 100 ? 'selected' : ''); ?>>100</option>
                            <option value="200" <?php echo e($perPage == 200 ? 'selected' : ''); ?>>200</option>
                        </select>
                    </div>
                    <div class="col-md-1">
                        <button type="submit" class="btn btn-outline-primary">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
                <div class="mt-2 row">
                    <div class="col-md-12">
                        <a href="<?php echo e(route('tickets.index')); ?>" class="btn btn-outline-secondary btn-sm">
                            <i class="fas fa-times"></i> Clear Filters
                        </a>
                        <a href="<?php echo e(route('tickets.export')); ?>?<?php echo e(http_build_query(request()->all())); ?>" class="btn btn-outline-success btn-sm">
                            <i class="fas fa-download"></i> Export CSV
                        </a>
                    </div>
                </div>
            </form>
        </div>

        <!-- Tickets Table -->
        <div class="table-responsive-container">
            <table class="table table-hover" id="ticketsTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Reference</th>
                        <th>Customer</th>
                        <th>Contact</th>
                        <th>School</th>
                        <th>Qty</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>STK Status</th>
                        <th>Payment Date</th>
                        <th>Created</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $checkDuplicate = []; $count = 1; ?>
                    <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($count++); ?></td>
                            <td>
                                <span class="ticket-reference"><?php echo e($ticket->reference); ?></span>
                            </td>
                            <td>
                                <strong><?php echo e($ticket->first_name); ?> <?php echo e($ticket->last_name); ?></strong>
                            </td>
                            <td>
                                <div class="scrollable-contact">
                                    <div>
                                        <i class="fas fa-phone text-primary"></i> <?php echo e($ticket->phone); ?><br>
                                        <i class="fas fa-envelope text-info"></i> <?php echo e($ticket->email); ?>

                                    </div>
                                </div>
                            </td>
                            <td>
                                <?php if($ticket->school): ?>
                                    <span class="badge bg-secondary school-badge"><?php echo e($ticket->school); ?></span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <span class="badge bg-info"><?php echo e($ticket->quantity); ?></span>
                            </td>
                            <td>
                                <div class="amount-display">
                                    KSH <?php echo e(number_format($ticket->total_amount, 2)); ?>

                                </div>
                                <small class="text-muted">@ KSH <?php echo e(number_format($ticket->amount, 2)); ?>/ticket</small>
                            </td>
                            <td>
                                <?php if($ticket->payment_status === 'completed'): ?>
                                    <span class="badge status-badge badge-success status-completed">
                                        <i class="fas fa-check"></i> Paid
                                    </span>
                                    <?php if($ticket->mpesa_receipt_number): ?>
                                        <br><small class="text-muted"><?php echo e($ticket->mpesa_receipt_number); ?></small>
                                    <?php endif; ?>
                                <?php elseif($ticket->payment_status === 'pending'): ?>
                                    <span class="badge status-badge bg-warning text-dark status-pending">
                                        <i class="fas fa-clock"></i> Pending
                                    </span>
                                <?php else: ?>
                                    <span class="bg-white badge status-badge text-danger status-failed">
                                        <i class="fas fa-times"></i> Failed
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($ticket->stk_status): ?>
                                    <?php if($ticket->stk_status === 'Success'): ?>
                                        <span class="text-white badge status-badge bg-success stk-status-success">
                                            <i class="fas fa-check"></i> Success
                                        </span>
                                    <?php elseif($ticket->stk_status === 'Launched'): ?>
                                        <span class="text-white badge status-badge bg-success stk-status-pending">
                                            <i class="fas fa-clock"></i> Launched
                                        </span>
                                    <?php elseif($ticket->stk_status === 'Failed'): ?>
                                        <span class="text-white badge status-badge bg-danger stk-status-failed">
                                            <i class="fas fa-times"></i> Failed
                                        </span>
                                    <?php elseif($ticket->stk_status === 'Canceled'): ?>
                                        <span class="text-white badge status-badge bg-info stk-status-canceled">
                                            <i class="fas fa-ban"></i> Canceled
                                        </span>
                                    <?php elseif($ticket->stk_status === 'Timeout'): ?>
                                        <span class="text-white badge status-badge bg-danger stk-status-timeout">
                                            <i class="fas fa-clock"></i> Timeout
                                        </span>
                                    <?php elseif($ticket->stk_status === 'insufficient-funds'): ?>
                                        <span class="badge status-badge stk-status-insufficient">
                                            <i class="fas fa-wallet"></i> Insufficient
                                        </span>
                                    <?php elseif($ticket->stk_status === 'User-cannot-be-reached'): ?>
                                        <span class="badge status-badge bg-secondary" style="background:#424242;color:#fff;">
                                            <i class="fas fa-user-times"></i> No Contact
                                        </span>
                                    <?php elseif($ticket->stk_status === 'No-response-from-user'): ?>
                                        <span class="badge status-badge bg-secondary" style="background:#424242;color:#fff;">
                                            <i class="fas fa-user-times"></i> No Response
                                        </span>
                                    <?php elseif($ticket->stk_status === 'Invalid-user-input'): ?>
                                        <span class="text-white badge status-badge bg-info stk-status-invalid-input">
                                            <i class="fas fa-exclamation-triangle"></i> Invalid Input
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-info status-badge">
                                            <?php echo e(ucfirst($ticket->stk_status)); ?>

                                        </span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="scrollable-payment-date">
                                    <?php if($ticket->payment_date && $ticket->payment_date instanceof \Carbon\Carbon): ?>
                                        <?php echo e($ticket->payment_date->format('d/m/Y H:i')); ?>

                                    <?php elseif($ticket->payment_date): ?>
                                        <?php echo e(\Carbon\Carbon::parse($ticket->payment_date)->format('d/m/Y H:i')); ?>

                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <?php echo e($ticket->created_at ? $ticket->created_at->format('d/m/Y H:i') : '-'); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="11" class="py-5 text-center">
                                <i class="mb-3 fas fa-ticket-alt fa-3x text-muted"></i>
                                <h4 class="text-muted">No tickets found</h4>
                                <p class="text-muted">Try adjusting your search filters</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Summary -->
        <div class="mt-3 text-center">
            <small class="text-muted">
                Showing <?php echo e($tickets->firstItem() ?? 0); ?> to <?php echo e($tickets->lastItem() ?? 0); ?> 
                of <?php echo e($tickets->total()); ?> total tickets
            </small>
        </div>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\dashboard.blade.php ENDPATH**/ ?>