<?php
    use Illuminate\Support\Str;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>E-Ticket | <?php echo e($event?->venue ?? 'Pace Event'); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.11.3/font/bootstrap-icons.min.css" rel="stylesheet"/>
    
    <style>
        :root {
            --card-bg: #ffffff;
            --text-dark: #212529;
            --accent: #ff7f45;
            --divider: rgba(0,0,0,0.075);
        }
        body {
            background:#f8f9fa;
            color: var(--text-dark);
            font-family: "Inter", sans-serif;
        }
        .ticket-wrapper{
            max-width: 420px;
            margin: 2rem auto;
        }
        .tickets-container{
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
            max-width: 100%;
            margin: 2rem auto;
            padding: 0 1rem;
        }
        .ticket-card{
            background: var(--card-bg);
            border-radius: 1rem;
            overflow:hidden;
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,.15);
            width: 100%;
            max-width: 100%;
        }
        .ticket-content{
            display: flex;
            align-items: center;
            min-height: 200px;
        }
        .ticket-left{
            flex: 1;
            padding: 1.5rem;
        }
        .ticket-right{
            flex: 0 0 200px;
            padding: 1.5rem;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            background: #f8f9fa;
            border-left: 1px dashed var(--divider);
        }
        @media (max-width: 768px) {
            .ticket-content {
                flex-direction: column;
                min-height: auto;
            }
            .ticket-left {
                padding: 1rem;
            }
            .ticket-right {
                flex: none;
                width: 100%;
                border-left: none;
                border-top: 1px dashed var(--divider);
                padding: 1rem;
            }
        }
        .event-header{
            display: flex;
            gap: 1rem;
            align-items: center;
            margin-bottom: 1rem;
        }
        .event-header img{
            width: 60px;
            height: 60px;
            object-fit: cover;
            border-radius: .5rem;
            flex-shrink: 0;
        }
        .event-info {
            flex: 1;
        }
        .event-info h5 {
            margin: 0 0 0.25rem 0;
            font-size: 1.1rem;
        }
        .event-info small {
            display: block;
            margin-bottom: 0.25rem;
        }
        .chip{
            font-size:.7rem;
            background:#e9ecef;
            color:#6c757d;
            padding:.2rem .6rem;
            border-radius:999px;
            text-transform:uppercase;
            letter-spacing:.05em;
        }
        .divider{
            border-top:1px dashed var(--divider);
            margin:0 1rem;
        }
        .qr-section{
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 0.5rem;
        }
        .qr-section img {
            width: 120px;
            height: 120px;
        }
        .ticket-number-badge {
            background: var(--accent);
            color: white;
            padding: 0.25rem 0.75rem;
            border-radius: 999px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        .terms{
            background:#f1f3f5;
            padding:0.75rem 1rem;
            font-size:.75rem;
        }
        @media (max-width: 768px) {
            .terms {
                padding: 0.5rem 0.75rem;
                font-size: 0.7rem;
            }
        }
        .btn-download{
            border-radius:2rem;
            font-weight:600;
            letter-spacing:.03em;
            background: var(--accent);
            border:none;
            margin-bottom:1.5rem;
        }
        .ticket-number{
            background: var(--accent);
            color: white;
            font-size: 0.7rem;
            padding: 0.2rem 0.5rem;
            border-radius: 999px;
            font-weight: 600;
            margin-left: 0.5rem;
        }
        .details-table td{
            padding:.25rem 0;
        }
        .copy-btn{
            cursor:pointer;
        }
    </style>
</head>
<body>
    <?php if($ticket->quantity > 1): ?>
        <div class="tickets-container">
            <?php for($i = 1; $i <= $ticket->quantity; $i++): ?>
                <div class="ticket-card shadow-lg">
                    <div class="ticket-content">
                        <!-- Left Side - Event Info & Details -->
                        <div class="ticket-left">
                            <!-- Event Header -->
                            <div class="event-header">
                                <?php
                                    $imgPath = $event?->event_image;
                                    if ($imgPath) {
                                        $imageSrc = Str::startsWith($imgPath, ['http://','https://']) ? $imgPath : asset($imgPath);
                                    } else {
                                        $imageSrc = 'https://placehold.co/150x150?text=Event';
                                    }
                                ?>
                                <img src="<?php echo e($imageSrc); ?>" alt="event" class="event-img"/>
                                <div class="event-info">
                                    <span class="chip">Festival</span>
                                    <h5 class="fw-semibold"><?php echo e($event?->title ?? 'Pace Teens Festival 2025'); ?></h5>
                                    <small class="text-muted d-block"><?php echo e($event?->venue ?? 'KICC Grounds, Nairobi'); ?></small>
                                    <small class="text-muted"><?php echo e(\Carbon\Carbon::parse($event?->date)->format('M d, Y')); ?></small>
                                </div>
                            </div>
                            
                            <!-- Details Table -->
                            <table class="w-100 details-table">
                                <tr>
                                    <td class="text-muted small">Attendee</td>
                                    <td class="fw-medium"><?php echo e($ticket->first_name ?? ''); ?> <?php echo e($ticket->last_name ?? ''); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-muted small">Ticket</td>
                                    <td><?php echo e($i); ?> of <?php echo e($ticket->quantity); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-muted small">Purchased On</td>
                                    <td><?php echo e($ticket->created_at->timezone('Africa/Nairobi')->format('M d, Y')); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-muted small">Amount</td>
                                    <td>Ksh <?php echo e(number_format($ticket->total_amount / $ticket->quantity, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-muted small">Booking Code</td>
                                    <td>
                                        <span id="bookingCode<?php echo e($i); ?>" class="me-2"><?php echo e($ticket->reference); ?>-<?php echo e($i); ?></span>
                                        <i class="bi bi-clipboard copy-btn" onclick="copyCode('bookingCode<?php echo e($i); ?>')"></i>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        
                        <!-- Right Side - QR Code & Download -->
                        <div class="ticket-right">
                            <div class="qr-section">
                                <div class="ticket-number-badge">Ticket <?php echo e($i); ?></div>
                                <img src="https://api.qrserver.com/v1/create-qr-code/?size=120x120&data=<?php echo e(urlencode($ticket->reference . '-' . $i)); ?>" alt="QR" class="rounded"/>
                            </div>
                            <button class="btn btn-download w-100 py-2 mt-3" onclick="downloadTicket(<?php echo e($i); ?>)">Download</button>
                        </div>
                    </div>
                </div>
            <?php endfor; ?>
        </div>
    <?php else: ?>
        <div class="ticket-wrapper">
            <div class="ticket-card shadow-lg">
                <!-- Header -->
                <div class="event-header">
                    <?php
                        $imgPath = $event?->event_image;
                        if ($imgPath) {
                            $imageSrc = Str::startsWith($imgPath, ['http://','https://']) ? $imgPath : asset($imgPath);
                        } else {
                            $imageSrc = 'https://placehold.co/150x150?text=Event';
                        }
                    ?>
                    <img src="<?php echo e($imageSrc); ?>" alt="event" class="event-img"/>
                    <div class="flex-grow-1">
                        <span class="chip">Festival</span>
                        <h5 class="mt-2 mb-1 fw-semibold"><?php echo e($event?->title ?? 'Pace Teens Festival 2025'); ?></h5>
                        <small class="text-muted d-block mb-1"><?php echo e($event?->venue ?? 'KICC Grounds, Nairobi'); ?></small>
                       
                        <small class="text-muted"><?php echo e(\Carbon\Carbon::parse($event?->date)->format('M d, Y')); ?></small>
                        
                    </div>
                </div>
                <div class="divider"></div>
                <!-- Details -->
                <div class="px-4 py-3">
                    <table class="w-100 details-table">
                        <tr>
                            <td class="text-muted small">Attendee </td><td class="fw-medium"><?php echo e($ticket->first_name ?? ''); ?> <?php echo e($ticket->last_name ?? ''); ?></td>
                        </tr>
                        <tr>
                            <td class="text-muted small">Quantity</td><td><?php echo e($ticket->quantity); ?></td>
                        </tr>
                        <tr>
                            <td class="text-muted small">Purchased On</td><td><?php echo e($ticket->created_at->timezone('Africa/Nairobi')->format('M d, Y')); ?></td>
                        </tr>
                        <tr>
                            <td class="text-muted small">Amount </td><td>Ksh <?php echo e(number_format($ticket->total_amount, 2)); ?></td>
                        </tr>
                        <tr>
                            <td class="text-muted small">Booking Code</td>
                            <td>
                                <span id="bookingCode" class="me-2"><?php echo e($ticket->reference); ?></span>
                                <i class="bi bi-clipboard copy-btn" onclick="copyCode('bookingCode')"></i>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="divider"></div>
                <!-- QR -->
                <div class="qr-section">
                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=180x180&data=<?php echo e(urlencode($ticket->reference)); ?>" alt="QR" class="rounded"/>
                </div>
                <div class="divider"></div>
                <!-- Terms -->
                <div class="terms">
                    <h6 class="fw-semibold mb-2">Terms &amp; Conditions</h6>
                    <ul class="mb-0">
                        <li>Tickets are non-refundable unless event is canceled.</li>
                        <li>Present valid ID alongside this e-ticket.</li>
                        <li>Unauthorized duplication is prohibited.</li>
                    </ul>
                </div>
            </div>
            <button class="btn btn-download w-100 py-3 mt-3" onclick="window.print()">Download Ticket</button>
        </div>
    <?php endif; ?>

    <script>
        function copyCode(elementId){
            const code = document.getElementById(elementId).innerText;
            navigator.clipboard.writeText(code).then(()=>{
                alert('Booking code copied');
            });
        }
        
        function downloadTicket(ticketNumber) {
            // Create a new window for printing individual ticket
            const printWindow = window.open('', '_blank');
            const ticketElement = document.querySelector(`button[onclick="downloadTicket(${ticketNumber})"]`).closest('.ticket-card');
            
            printWindow.document.write(`
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Ticket ${ticketNumber}</title>
                    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
                    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.11.3/font/bootstrap-icons.min.css" rel="stylesheet"/>
                    <style>
                        body { margin: 0; padding: 20px; }
                        .ticket-card { max-width: 400px; margin: 0 auto; }
                        @media print {
                            body { margin: 0; padding: 0; }
                        }
                    </style>
                </head>
                <body>
                    ${ticketElement.outerHTML}
                </body>
                </html>
            `);
            printWindow.document.close();
            
            // Auto-print after a short delay
            setTimeout(() => {
                printWindow.print();
            }, 500);
        }
    </script>
</body>
</html> 
</html> <?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\ticket\download_cp.blade.php ENDPATH**/ ?>