<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Your PACE TeenzFest Ticket</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            border-bottom: 3px solid #007bff;
        }
        .header img {
            max-width: 200px;
            height: auto;
            margin-bottom: 15px;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
        .content {
            padding: 20px;
        }
        .ticket-details {
            background-color: #f8f9fa;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="https://stagingpacesetter.vouchatt.com/assets/img/logo/logo.png" alt="PACE TeenzFest Logo">
            <h1>PACE TeenzFest 2025</h1>
            <p>Your Ticket Confirmation</p>
        </div>
        
        <div class="content">
            <p>Dear <?php echo e($ticket->first_name); ?> <?php echo e($ticket->last_name); ?>,</p>
            
            <p>Thank you for purchasing tickets to <?php echo e($event->name); ?>. Your ticket details are below:</p>
            
            <div class="ticket-details">
                <p><strong>Event:</strong> <?php echo e($event->name); ?></p>
                <p><strong>Date:</strong> <?php echo e(\Carbon\Carbon::parse($event->date)->format('l, jS F Y')); ?></p>
                <p><strong>Venue:</strong> <?php echo e($event->venue); ?></p>
                <p><strong>Ticket Reference:</strong> <?php echo e($ticket->reference); ?></p>
                <p><strong>Number of Tickets:</strong> <?php echo e($ticket->quantity); ?></p>
                <p><strong>Amount Paid:</strong> KSH <?php echo e(number_format($ticket->total_amount, 2)); ?></p>
                <p><strong>Payment Status:</strong> Confirmed</p>
                <p><strong>M-Pesa Receipt:</strong> <?php echo e($ticket->mpesa_receipt_number); ?></p>
            </div>

            <p>To download your ticket, please click the button below:</p>
            
            <a href="<?php echo e($downloadUrl); ?>" class="button">Download Ticket</a>
            
            <p>Important Information:</p>
            <ul>
                <li>Please arrive at least 30 minutes before the event starts</li>
                <li>Bring a valid form of identification</li>
                <li>Your ticket will be scanned at the entrance</li>
            </ul>
        </div>

        <div class="footer">
            <p>This is an automated message, please do not reply to this email.</p>
            <p>For any queries, please contact us at support@paceteenzfest.com</p>
            <p>&copy; <?php echo e(date('Y')); ?> PACE TeenzFest. All rights reserved.</p>
        </div>
    </div>
</body>
</html><?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\emails\ticket.blade.php ENDPATH**/ ?>