<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Message Templates - PaceEvents</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        .template-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        .template-card {
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            transition: all 0.3s ease;
        }
        .template-card:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #5a6fd8 0%, #6a4190 100%);
        }
        .status-badge {
            font-size: 0.75rem;
        }
    </style>
</head>
<body>
    <div class="template-container">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="h3 mb-1"><i class="fas fa-envelope-open-text text-primary"></i> Message Templates</h1>
                <p class="text-muted">Manage your SMS message templates</p>
            </div>
            <a href="<?php echo e(route('admin.message-templates.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create Template
            </a>
        </div>

        <!-- Success/Error Messages -->
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle"></i> <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Templates Grid -->
        <?php if($templates->count() > 0): ?>
            <div class="row">
                <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6 col-lg-4 mb-4">
                        <div class="card template-card h-100">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <h5 class="card-title mb-0"><?php echo e($template->name); ?></h5>
                                    <span class="badge <?php echo e($template->is_active ? 'bg-success' : 'bg-secondary'); ?> status-badge">
                                        <?php echo e($template->is_active ? 'Active' : 'Inactive'); ?>

                                    </span>
                                </div>
                                
                                <?php if($template->description): ?>
                                    <p class="text-muted small mb-2"><?php echo e($template->description); ?></p>
                                <?php endif; ?>
                                
                                <div class="template-preview mb-3">
                                    <small class="text-muted">Preview:</small>
                                    <p class="border rounded p-2 bg-light small mb-0" style="max-height: 80px; overflow-y: auto;">
                                        <?php echo e(Str::limit($template->content, 150)); ?>

                                    </p>
                                </div>
                                
                                <div class="d-flex justify-content-between align-items-center">
                                    <small class="text-muted">
                                        <i class="fas fa-clock"></i> <?php echo e($template->created_at->format('M d, Y')); ?>

                                    </small>
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo e(route('admin.message-templates.edit', $template)); ?>" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-edit"></i>
                        </a>
                                        <button type="button" class="btn btn-outline-danger btn-sm" 
                                                onclick="deleteTemplate(<?php echo e($template->id); ?>, '<?php echo e($template->name); ?>')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-envelope-open-text fa-3x text-muted mb-3"></i>
                <h4 class="text-muted">No Message Templates</h4>
                <p class="text-muted mb-4">Create your first message template to get started</p>
                <a href="<?php echo e(route('admin.message-templates.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create Your First Template
                </a>
            </div>
        <?php endif; ?>

        <!-- Back Link -->
        <div class="text-center mt-4">
            <a href="<?php echo e(route('sms.index')); ?>" class="text-decoration-none">
                <i class="fas fa-arrow-left"></i> Back to SMS
            </a>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Confirm Delete</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the template <strong id="templateName"></strong>?</p>
                    <p class="text-danger"><i class="fas fa-exclamation-triangle"></i> This action cannot be undone!</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <form id="deleteForm" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger">Delete Template</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function deleteTemplate(id, name) {
            document.getElementById('templateName').textContent = name;
            document.getElementById('deleteForm').action = `/admin/message-templates/${id}`;
            new bootstrap.Modal(document.getElementById('deleteModal')).show();
        }
    </script>
</body>
</html><?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\message-templates\index.blade.php ENDPATH**/ ?>