<!DOCTYPE html>
<html>
<head>
    <title>Complimentary Ticket Preview - <?php echo e($ticket->event->name); ?></title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
        }
        .ticket-container {
            max-width: 600px;
            margin: 0 auto;
            background: #fff;
            border: 2px dashed #4e2a87;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: relative;
            background-image: url('<?php echo e(asset('assets/img/logo/logo.png')); ?>');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-blend-mode: overlay;
            background-color: rgba(255, 255, 255, 0.9);
        }
        .watermark {
            position: absolute;
            opacity: 0.08;
            font-size: 60px;
            font-weight: bold;
            color: #4e2a87;
            transform: rotate(-30deg);
            top: 20%;
            left: 5%;
            width: 100%;
            text-align: center;
            z-index: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #4e2a87;
            padding-bottom: 10px;
            position: relative;
            z-index: 1;
        }
        .details {
            margin-bottom: 20px;
            padding: 15px;
            background-color: rgba(255, 255, 255, 0.7);
            border-radius: 8px;
            position: relative;
            z-index: 1;
        }
        .ticket-type {
            background: #4e2a87;
            color: white;
            padding: 6px 12px;
            border-radius: 20px;
            display: inline-block;
            margin: 10px 0;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 12px;
        }
        h1 {
            color: #4e2a87;
            font-size: 24px;
            margin-bottom: 10px;
        }
        .details p {
            margin: 6px 0;
            font-size: 14px;
        }
        .details strong {
            color: #4e2a87;
            min-width: 90px;
            display: inline-block;
        }
        .event-date {
            font-weight: bold;
            color: #4e2a87;
            font-size: 16px;
            margin: 10px 0;
            text-align: center;
        }
        .download-button {
            text-align: center;
            margin-top: 20px;
            position: relative;
            z-index: 1;
        }
        .download-button a, .download-button button {
            display: inline-block;
            padding: 10px 20px;
            background: #4e2a87;
            color: white;
            text-decoration: none;
            border: none;
            border-radius: 5px;
            font-weight: bold;
            transition: background 0.3s;
            cursor: pointer;
            margin: 5px;
        }
        .download-button a:hover, .download-button button:hover {
            background: #3a1f66;
        }
        .copy-note {
            text-align: center;
            font-size: 12px;
            color: #333;
            margin-top: 10px;
            position: relative;
            z-index: 1;
        }
        .footer {
            text-align: center;
            font-size: 11px;
            margin-top: 20px;
            border-top: 2px solid #4e2a87;
            padding-top: 10px;
            position: relative;
            z-index: 1;
        }
    </style>
</head>
<body>
    <div class="ticket-container">
        <div class="watermark">COMPLIMENTARY</div>
        
        <div class="header">
            <h1><?php echo e($ticket->event->name); ?></h1>
            <div class="ticket-type">Complimentary Ticket</div>
            <div class="event-date">
                <?php echo e($ticket->event->date->format('l, F j, Y')); ?><br>
                <?php echo e($ticket->event->start_time ?? 'Time: From 8:00 a.m'); ?>

            </div>
        </div>
        
        <div class="details">
            <p><strong>Guest Name:</strong> <?php echo e($ticket->first_name); ?> <?php echo e($ticket->last_name); ?></p>
            <p><strong>Venue:</strong> <?php echo e($ticket->event->venue); ?></p>
            <p><strong>Ticket Reference:</strong> <?php echo e($ticket->reference); ?></p>
            <p><strong>Issued By:</strong> <?php echo e($ticket->generated_by_name ?? 'Pacesetter Entertainment'); ?></p>
        </div>
        
        <div class="download-button">
            <a href="<?php echo e(route('complimentary.ticket.download', $ticket->id)); ?>" target="_blank">Download Ticket as PDF</a>
            <button onclick="copyLink()">Copy Download Link</button>
        </div>
        <div class="copy-note">
            <p>If you don't want to download now, please copy the link using the button above.</p>
        </div>
        
        <div class="footer">
            <p>This complimentary ticket grants one-time entry to the specified event</p>
            <p>Not transferable • Not for resale • No cash value</p>
            <p>For inquiries, contact: Thepacesettertalentshow@gmail.com | +254 726 846 918</p>
        </div>
    </div>

    <script>
        function copyLink() {
            const link = "<?php echo e(route('complimentary.ticket.preview', $ticket->id)); ?>";
            navigator.clipboard.writeText(link).then(() => {
                alert('Download link copied to clipboard!');
            }).catch(err => {
                console.error('Failed to copy link: ', err);
                alert('Failed to copy link. Please try again.');
            });
        }
    </script>
</body>
</html><?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\complimentary\ticket-preview.blade.php ENDPATH**/ ?>