<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CSV Processing Results - PACE Events</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        body {
            background-color: #f8f9fa;
        }
        .card {
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            border: 1px solid rgba(0, 0, 0, 0.125);
        }
        .card-header {
            background-color: #6c757d;
            color: white;
        }
        .stats-card {
            transition: transform 0.2s;
        }
        .stats-card:hover {
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="card">
                    <div class="card-header">
                        <h4><i class="fas fa-chart-bar"></i> CSV Processing Results</h4>
                    </div>
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-md-2">
                                <div class="card bg-primary text-white stats-card">
                                    <div class="card-body text-center">
                                        <h5><?php echo e($results['processed']); ?></h5>
                                        <small>Total Processed</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="card bg-success text-white stats-card">
                                    <div class="card-body text-center">
                                        <h5><?php echo e($results['transactions_created']); ?></h5>
                                        <small>Transactions Created</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="card bg-info text-white stats-card">
                                    <div class="card-body text-center">
                                        <h5><?php echo e($results['transactions_existed']); ?></h5>
                                        <small>Transactions Existed</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="card bg-info text-white stats-card">
                                    <div class="card-body text-center">
                                        <h5><?php echo e($results['tickets_updated']); ?></h5>
                                        <small>Tickets Updated</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="card bg-success text-white stats-card">
                                    <div class="card-body text-center">
                                        <h5><?php echo e($results['sms_sent']); ?></h5>
                                        <small>SMS Sent</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="card bg-danger text-white stats-card">
                                    <div class="card-body text-center">
                                        <h5><?php echo e($results['sms_failed']); ?></h5>
                                        <small>SMS Failed</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php if(count($results['errors']) > 0): ?>
                            <div class="alert alert-danger">
                                <h6><i class="fas fa-exclamation-triangle"></i> Errors Found:</h6>
                                <ul class="mb-0">
                                    <?php $__currentLoopData = $results['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <div class="alert alert-success">
                            <h6><i class="fas fa-check-circle"></i> Processing Summary:</h6>
                            <ul class="mb-0">
                                <li><strong><?php echo e($results['processed']); ?></strong> records were processed from the CSV</li>
                                <li><strong><?php echo e($results['transactions_created']); ?></strong> new transaction records were created</li>
                                <li><strong><?php echo e($results['transactions_existed']); ?></strong> transactions already existed (users already received SMS)</li>
                                <li><strong><?php echo e($results['tickets_updated']); ?></strong> tickets were updated with payment status</li>
                                <li><strong><?php echo e($results['sms_sent']); ?></strong> SMS notifications were sent to users</li>
                                <li><strong><?php echo e($results['sms_failed']); ?></strong> SMS notifications failed to send</li>
                            </ul>
                        </div>

                        <div class="mt-4">
                            <a href="<?php echo e(route('csv.index')); ?>" class="btn btn-primary">
                                <i class="fas fa-arrow-left"></i> Process Another CSV
                            </a>
                            <a href="<?php echo e(route('tickets.index')); ?>" class="btn btn-secondary">
                                <i class="fas fa-ticket-alt"></i> View Tickets
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\csv-processor\results.blade.php ENDPATH**/ ?>