<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PACE - Complimentary Tickets Dashboard</title>
    <meta name="description" content="View all complimentary tickets for PACE events">
    <meta name="description" content="PACE Events" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <!-- Primary Meta Tags -->
        <meta name="title" content="PACE" />
        <meta name="description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
    
        <!-- Open Graph / Facebook -->
        <meta property="og:type" content="website" />
        <meta property="og:url" content="https://pace-gules.vercel.app/" />
        <meta property="og:title" content="PACE" />
        <meta property="og:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="og:image" content="https://pace-gules.vercel.app/assets/img/logo/logo.png" />
    
        <!-- Twitter -->
        <meta property="twitter:card" content="summary_large_image" />
        <meta property="twitter:url" content="https://pace-gules.vercel.app/" />
        <meta property="twitter:title" content="PACE" />
        <meta property="twitter:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="twitter:image" content="https://pace-gules.vercel.app/assets/img/logo/logo.png" />
    
    
        <link
          rel="shortcut icon"
          type="image/x-icon"
          href="assets/img/logo/logo.png"
        />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css" rel="stylesheet">
    <!-- Toastr CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <style>
        /* Main Container Styles */
        .tickets-container {
            width: 100%;
            margin: 0 auto;
            padding: 1rem;
            overflow-x: hidden;
        }

        /* Stats Cards */
        .stats-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 1rem;
            text-align: center;
            min-width: 150px;
        }

        .stats-card.success {
            background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        }

        .stats-card.warning {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        }

        .stats-card.info {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        }

        .stats-card.danger {
            background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
        }

        /* Navigation Row */
        .navigation-row {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        /* Buttons */
        .btn-primary {
            background-color: #6c04f5;
            border-color: #6c04f5;
        }

        .btn-primary:hover {
            background-color: #5a03d1;
            border-color: #5a03d1;
        }

         /* Navigation Row */
        .navigation-row {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        /* Buttons */
        .btn-primary {
            background-color: #6c04f5;
            border-color: #6c04f5;
        }

        .btn-primary:hover {
            background-color: #5a03d1;
            border-color: #5a03d1;
        }

        /* Action Buttons Container */
        .action-buttons {
            position: absolute;
            top: 70px; /* Below top nav */
            right: 1rem;
            z-index: 1000;
            display: flex;
            gap: 0.5rem;
        }

        .action-buttons .btn {
            font-size: 0.9rem;
            padding: 0.5rem 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }


        /* Search Filters */
        .search-filters {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 1rem;
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
        }

        .search-filters .form-group {
            flex: 1 1 100%;
            min-width: 0;
        }

        .search-filters .form-control,
        .search-filters .form-select {
            font-size: 0.9rem;
        }

        /* Table Container */
        .table-responsive-container {
            overflow-x: auto;
            background: white;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }

        .table {
            width: 100%;
            margin-bottom: 0;
        }

        /* Scrollbar Styling */
        .table-responsive-container::-webkit-scrollbar {
            height: 8px;
        }

        .table-responsive-container::-webkit-scrollbar-track {
            background: #f8f9fa;
            border-radius: 5px;
        }

        .table-responsive-container::-webkit-scrollbar-thumb {
            background: #6c04f5;
            border-radius: 5px;
        }

        .table-responsive-container::-webkit-scrollbar-thumb:hover {
            background: #5a03d1;
        }

        .scrollable-contact {
            max-width: 100%;
            overflow-x: auto;
            white-space: nowrap;
        }

        .scrollable-contact::-webkit-scrollbar {
            height: 4px;
        }

        .scrollable-contact::-webkit-scrollbar-thumb {
            background: #6c04f5;
            border-radius: 2px;
        }

        .table th {
            background-color: #6c04f5;
            color: white;
            border: none;
            font-weight: 600;
            padding: 0.5rem;
            position: sticky;
            top: 0;
            z-index: 10;
            white-space: nowrap;
        }

        .table td {
            vertical-align: middle;
            padding: 0.5rem;
            white-space: nowrap;
        }

        /* Status Badges */
        .status-badge {
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
            border-radius: 0.25rem;
            display: inline-block;
            white-space: nowrap;
        }

        .status-sent {
            background-color: #28a745;
            color: white;
        }

        .status-pending {
            background-color: #ffc107;
            color: #212529;
        }

        .status-failed {
            background-color: #dc3545;
            color: white;
        }

        /* Ticket Code */
        .ticket-reference {
            font-family: 'Courier New', monospace;
            font-size: 0.85rem;
            background-color: #f8f9fa;
            padding: 0.25rem 0.5rem;
            border-radius: 0.25rem;
            white-space: nowrap;
        }

        /* Pagination */
        .pagination {
            --bs-pagination-padding-x: 0.75rem;
            --bs-pagination-padding-y: 0.375rem;
            --bs-pagination-font-size: 0.875rem;
            --bs-pagination-color: #6c04f5;
            --bs-pagination-bg: #fff;
            --bs-pagination-border-width: 1px;
            --bs-pagination-border-color: #dee2e6;
            --bs-pagination-border-radius: 0.375rem;
            --bs-pagination-hover-color: #5a03d1;
            --bs-pagination-hover-bg: #f8f9ff;
            --bs-pagination-hover-border-color: #6c04f5;
            --bs-pagination-focus-color: #5a03d1;
            --bs-pagination-focus-bg: #f8f9ff;
            --bs-pagination-focus-box-shadow: 0 0 0 0.25rem rgba(108, 4, 245, 0.25);
            --bs-pagination-active-color: #fff;
            --bs-pagination-active-bg: #6c04f5;
            --bs-pagination-active-border-color: #6c04f5;
            --bs-pagination-disabled-color: #6c757d;
            --bs-pagination-disabled-bg: #fff;
            --bs-pagination-disabled-border-color: #dee2e6;
        }

        .pagination .page-link {
            border-radius: 0.375rem !important;
            margin: 0 0.125rem;
        }

        /* DataTables Custom Styling */
        .dataTables_wrapper {
            margin: 0.5rem 0;
        }

        .dataTables_wrapper .dataTables_length,
        .dataTables_wrapper .dataTables_filter,
        .dataTables_wrapper .dataTables_info,
        .dataTables_wrapper .dataTables_paginate {
            padding: 0.5rem;
            background-color: #f8f9fa;
            border-radius: 0.5rem;
            margin: 0.5rem 0;
        }

        .dataTables_wrapper .dataTables_length select,
        .dataTables_wrapper .dataTables_filter input {
            border: 1px solid #dee2e6;
            border-radius: 0.375rem;
            padding: 0.375rem 0.75rem;
            font-size: 0.9rem;
        }

        .dataTables_wrapper .dataTables_paginate {
            text-align: center;
            float: none;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button {
            border-radius: 0.375rem !important;
            margin: 0 0.125rem;
            border: 1px solid #dee2e6;
            padding: 0.375rem 0.75rem !important;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button.current {
            background: #6c04f5 !important;
            border-color: #6c04f5 !important;
            color: white !important;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
            background: #5a03d1 !important;
            border-color: #5a03d1 !important;
            color: white !important;
        }

        /* Alert Styling */
        .alert {
            padding: 8px 12px;
            margin-bottom: 15px;
            font-size: 0.85rem;
            border-radius: 4px;
        }

        /* Breadcrumb Area Styling */
        .td-breadcrumb-area {
            background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.1)), 
                        url("<?php echo e(asset('assets/img/logo/logo.png')); ?>") center center / cover no-repeat;
            padding: 40px 0;
            color: #fff;
            text-align: center;
            margin-bottom: 20px;
        }

        .breadcrumb-title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 8px;
        }

        /* Responsive Adjustments */
        @media (min-width: 576px) {
            .search-filters .form-group {
                flex: 1 1 45%;
            }
            .create-tickets-badge .btn {
                font-size: 1rem;
                padding: 0.75rem 1.25rem;
            }
        }

        @media (min-width: 768px) {
            .tickets-container {
                padding: 1.5rem;
            }
            .search-filters {
                padding: 1.5rem;
            }
            .search-filters .form-group {
                flex: 1 1 30%;
            }
            .stats-card {
                padding: 1.5rem;
                min-width: 180px;
            }
            .table th,
            .table td {
                padding: 0.75rem;
            }
            .breadcrumb-title {
                font-size: 28px;
            }
        }

        @media (min-width: 992px) {
            .search-filters .form-group {
                flex: 1 1 20%;
            }
            .table {
                font-size: 0.9rem;
            }
            .stats-card {
                min-width: 200px;
            }
            .breadcrumb-title {
                font-size: 32px;
            }
        }

        @media (max-width: 576px) {
            .table {
                font-size: 0.8rem;
            }
            .ticket-reference,
            .status-badge {
                font-size: 0.7rem;
            }
            .dataTables_wrapper .dataTables_paginate .paginate_button {
                padding: 0.25rem 0.5rem !important;
                margin: 0 0.1rem !important;
            }
            .td-breadcrumb-area {
                padding: 20px 0;
            }
            .breadcrumb-title {
                font-size: 20px;
            }
            .create-tickets-badge {
                top: 60px; /* Adjust for smaller screens */
                right: 0.5rem;
            }
            .create-tickets-badge .btn {
                font-size: 0.8rem;
                padding: 0.4rem 0.8rem;
            }
        }
    </style>
</head>
<body class="bg-light">
    <div class="mt-0">
        <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <!-- Action Buttons -->
    <div class="action-buttons">
        <a href="<?php echo e(route('complimentary.codes.create')); ?>" class="btn btn-primary">
            <i class="fas fa-ticket-alt"></i> Create Tickets
        </a>
        <a href="<?php echo e(route('manage.complimentary.tickets.index')); ?>" class="btn btn-primary">
            <i class="fas fa-cogs"></i> Manage Tickets
        </a>
    </div>

    <div class="container-fluid tickets-container">
        <!-- Messages -->
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle"></i>
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle"></i>
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Search and Filters -->
        <div class="search-filters">
            <form method="GET" action="<?php echo e(route('complimentary.index')); ?>" id="filter-form" aria-label="Ticket search and filter form">
                <div class="row align-items-end g-2">
                    <div class="form-group">
                        <label for="search" class="form-label">Search Tickets</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="<?php echo e(request('search')); ?>" placeholder="Code, recipient, phone, email" 
                               aria-label="Search by code, recipient, phone, or email">
                    </div>
                    <div class="form-group">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-select" id="status" name="status" aria-label="Filter by status">
                            <option value="">All Status</option>
                            <option value="sent" <?php echo e(request('status') === 'sent' ? 'selected' : ''); ?>>Sent</option>
                            <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                            <option value="failed" <?php echo e(request('status') === 'failed' ? 'selected' : ''); ?>>Failed</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="per_page" class="form-label">Per Page</label>
                        <select class="form-select" id="per_page" name="per_page" aria-label="Select entries per page">
                            <option value="25" <?php echo e(request('per_page') == 25 ? 'selected' : ''); ?>>25</option>
                            <option value="50" <?php echo e(request('per_page') == 50 ? 'selected' : ''); ?>>50</option>
                            <option value="100" <?php echo e(request('per_page') == 100 ? 'selected' : ''); ?>>100</option>
                            <option value="200" <?php echo e(request('per_page') == 200 ? 'selected' : ''); ?>>200</option>
                        </select>
                    </div>
                </div>
            </form>
        </div>

        <!-- Tickets Table -->
        <div class="table-responsive-container">
            <table class="table table-hover" id="" aria-label="Complimentary tickets table">
                <thead>
                    <tr>
                        <th scope="col">Code</th>
                        <th scope="col">Event</th>
                        <th scope="col">Recipient</th>
                        <th scope="col">Contact</th>
                        <th scope="col">Qty</th>
                        <th scope="col">Type</th>
                        <th scope="col"></th>SMS</th>
                        <th scope="col">Email</th>
                        <th scope="col">Expires</th>
                        <th scope="col">Created</th>
                        <th scope="col">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><span class="ticket-reference"><?php echo e($code->code); ?></span></td>
                            <td><?php echo e($code->event->name ?? 'N/A'); ?></td>
                            <td><strong><?php echo e($code->recipient_name ?? 'Unknown'); ?></strong></td>
                            <td>
                                <div class="scrollable-contact">
                                    <div>
                                        <?php if($code->recipient_phone): ?>
                                            <i class="fas fa-phone text-primary"></i> <?php echo e($code->recipient_phone); ?><br>
                                        <?php endif; ?>
                                        <?php if($code->recipient_email): ?>
                                            <i class="fas fa-envelope text-info"></i> <?php echo e($code->recipient_email); ?>

                                        <?php else: ?>
                                            <span class="text-muted">No contact info</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td class="text-center">
                                <span class="badge bg-info"><?php echo e($code->ticket_quantity ?? 0); ?></span>
                            </td>
                            <td>
                                <?php if($code->ticket_type === 'vip'): ?>
                                    <span class="badge" style="background-color: #6B46C1; color: white;">VIP</span>
                                <?php else: ?>
                                    <span class="badge" style="background-color: #D4AF37; color: white;">Normal</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="status-badge 
                                    <?php echo e($code->sms_status == 'sent' ? 'status-sent' : 
                                       ($code->sms_status == 'failed' ? 'status-failed' : 'status-pending')); ?>">
                                    <i class="fas <?php echo e($code->sms_status == 'sent' ? 'fa-check' : 
                                                    ($code->sms_status == 'failed' ? 'fa-times' : 'fa-clock')); ?>"></i>
                                    <?php echo e(ucfirst($code->sms_status ?? 'pending')); ?>

                                </span>
                            </td>
                            <td>
                                <span class="status-badge 
                                    <?php echo e($code->email_status == 'sent' ? 'status-sent' : 
                                       ($code->email_status == 'failed' ? 'status-failed' : 'status-pending')); ?>">
                                    <i class="fas <?php echo e($code->email_status == 'sent' ? 'fa-check' : 
                                                    ($code->email_status == 'failed' ? 'fa-times' : 'fa-clock')); ?>"></i>
                                    <?php echo e(ucfirst($code->email_status ?? 'pending')); ?>

                                </span>
                            </td>
                            <td><?php echo e(\Carbon\Carbon::parse($code->expires_at)->format('d/m/Y') ?? 'N/A'); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($code->created_at)->format('d/m/Y H:i') ?? 'N/A'); ?></td>
                            <td>
                                <form action="<?php echo e(route('complimentary.resend', $code->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to resend notifications?');">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-outline-primary" title="Resend Notifications">
                                        <i class="fas fa-paper-plane"></i> Resend
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="py-5 text-center">
                                <i class="mb-3 fas fa-ticket-alt fa-3x text-muted"></i>
                                <h4 class="text-muted">No complimentary tickets found</h4>
                                <p class="text-muted">Try adjusting your search filters or clearing the search</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <!-- Summary -->
        <div class="mt-3 text-center">
            <small class="text-muted">
                Showing <?php echo e($codes->firstItem() ?? 0); ?> to <?php echo e($codes->lastItem() ?? 0); ?> 
                of <?php echo e($codes->total()); ?> total tickets
                <?php if(request('search') || request('status')): ?>
                    (filtered)
                <?php endif; ?>
            </small>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
        $(document).ready(function() {
            // Initialize Toastr
            toastr.options = {
                closeButton: true,
                progressBar: true,
                positionClass: "toast-top-right",
                timeOut: 5000,
                extendedTimeOut: 10000,
                preventDuplicates: true
            };

            <?php if(session('success')): ?>
                toastr.success("<?php echo e(session('success')); ?>");
            <?php endif; ?>
            <?php if(session('error')): ?>
                toastr.error("<?php echo e(session('error')); ?>");
            <?php endif; ?>

            // Initialize DataTable
            var ticketsTable = $('#ticketsTable').DataTable({
                responsive: true,
                scrollX: true,
                scrollCollapse: true,
                paging: true,
                pageLength: <?php echo e(request('per_page', 30)); ?>,
                lengthMenu: [[25, 50, 100, 200], [25, 50, 100, 200]],
                dom: '<"top"<"row"<"col-12 col-md-6"l><"col-12 col-md-6"f>>>rt<"bottom"<"row"<"col-12 col-md-6"i><"col-12 col-md-6"p>>>',
                deferRender: true,
                processing: true,
                language: {
                    search: "_INPUT_",
                    searchPlaceholder: "Search tickets...",
                    lengthMenu: "Show _MENU_ tickets",
                    info: "Showing _START_ to _END_ of _TOTAL_ tickets",
                    infoEmpty: "No tickets found",
                    infoFiltered: "(filtered from _MAX_ total tickets)",
                    paginate: {
                        first: "First",
                        last: "Last",
                        next: "Next",
                        previous: "Prev"
                    },
                    emptyTable: "No tickets match your search criteria. Try adjusting your filters or clearing the search."
                },
                columnDefs: [
                    {
                        targets: 0, // Code
                        searchable: true,
                        responsivePriority: 1
                    },
                    {
                        targets: 2, // Recipient
                        searchable: true,
                        responsivePriority: 2
                    },
                    {
                        targets: 3, // Contact
                        searchable: true,
                        responsivePriority: 3,
                        render: function(data, type, row) {
                            if (type === 'display') {
                                let phone = row[3]?.match(/<i class="fas fa-phone text-primary"><\/i> (.*?)<br>/)?.[1] || '';
                                let email = row[3]?.match(/<i class="fas fa-envelope text-info"><\/i> (.*?)(?:$|<)/)?.[1] || '';
                                return phone + ' ' + email;
                            }
                            return data;
                        }
                    },
                    {
                        targets: 4, // Qty
                        responsivePriority: 4
                    },
                    {
                        targets: '_all',
                        searchable: false,
                        render: function(data, type, row) {
                            if (type === 'display' && data) {
                                return '<div style="white-space: nowrap;">' + data + '</div>';
                            }
                            return data;
                        }
                    }
                ],
                initComplete: function() {
                    // Sync DataTables search with form search input
                    var searchInput = $('#search').val();
                    if (searchInput) {
                        ticketsTable.search(searchInput).draw();
                    }

                    // Update table on search input change (DataTables search bar)
                    this.api().on('search.dt', function() {
                        var filteredRows = ticketsTable.rows({ filter: 'applied' }).count();
                        if (filteredRows === 0 && (ticketsTable.search() || $('#search').val())) {
                            toastr.warning('No tickets match your search criteria. Try different keywords or clear the search.');
                        }
                    });
                }
            });

            // Debounce function to limit search frequency
            function debounce(func, wait) {
                let timeout;
                return function executedFunction(...args) {
                    const later = () => {
                        clearTimeout(timeout);
                        func(...args);
                    };
                    clearTimeout(timeout);
                    timeout = setTimeout(later, wait);
                };
            }

            // Sync form search input with DataTables search
            $('#search').on('keyup change', debounce(function() {
                var searchValue = $(this).val();
                ticketsTable.search(searchValue).draw();
            }, 300));

            // Auto-submit filters on change
            $('#status, #per_page').change(function() {
                $('#filter-form').submit();
            });

            // Handle form submission to prevent conflicts
            $('#filter-form').on('submit', function(e) {
                e.preventDefault();
                var searchValue = $('#search').val();
                ticketsTable.search(searchValue).draw();
                // Submit form to server for server-side filtering
                this.submit();
            });

            // Window resize handler
            $(window).on('resize', function() {
                ticketsTable.columns.adjust().responsive.recalc();
            }).trigger('resize');
        });
    </script>
</body>
</html><?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\complimentary\index.blade.php ENDPATH**/ ?>